/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public abstract class OraclePartitionsHandler {
    static OraclePartitionsHandler create(DBObject object) {
        if (object instanceof TablePartition) {
            object = OraclePartitionsHandler.getOwningTable(object);
        }
        if (object instanceof Table) {
            object = (OracleTablePartitions)object.getProperty("OracleTablePartitions");
        }
        if (object instanceof IndexPartition) {
            object = object.getParent();
        }
        if (object instanceof Index) {
            object = (OracleIndexPartitions)object.getProperty("OracleIndexPartitions");
        }
        if (object instanceof OracleTablePartitions) {
            return new OracleTablePartitionsHandler((OracleTablePartitions)object);
        }
        if (object instanceof OracleIndexPartitions) {
            return new OracleIndexPartitionsHandler((OracleIndexPartitions)object);
        }
        throw new IllegalArgumentException("Cannot retrieve a partioning object from " + object);
    }

    public abstract void setHashQuantity(Integer var1);

    public abstract void setPartitions(DBObject[] var1);

    public abstract Integer getHashQuantity();

    public abstract DBObject[] getPartitions();

    public static Table getOwningTable(DBObject child) {
        if (child instanceof Table || child == null) {
            return (Table)child;
        }
        return OraclePartitionsHandler.getOwningTable(child.getParent());
    }

    private static class OracleIndexPartitionsHandler
    extends OraclePartitionsHandler {
        private final OracleIndexPartitions m_oip;

        private OracleIndexPartitionsHandler(OracleIndexPartitions oip) {
            this.m_oip = oip;
        }

        @Override
        public Integer getHashQuantity() {
            return this.m_oip.getGlobalHashQuantity();
        }

        @Override
        public void setHashQuantity(Integer quantity) {
            this.m_oip.setGlobalHashQuantity(quantity);
        }

        @Override
        public DBObject[] getPartitions() {
            return this.m_oip.getPartitions();
        }

        @Override
        public void setPartitions(DBObject[] partitions) {
            this.m_oip.setPartitions((IndexPartition[])partitions);
        }
    }

    private static class OracleTablePartitionsHandler
    extends OraclePartitionsHandler {
        private final OracleTablePartitions m_otp;

        private OracleTablePartitionsHandler(OracleTablePartitions otp) {
            this.m_otp = otp;
        }

        @Override
        public Integer getHashQuantity() {
            return this.m_otp.getHashQuantity();
        }

        @Override
        public void setHashQuantity(Integer quantity) {
            this.m_otp.setHashQuantity(quantity);
        }

        @Override
        public DBObject[] getPartitions() {
            return this.m_otp.getPartitions();
        }

        @Override
        public void setPartitions(DBObject[] partitions) {
            this.m_otp.setPartitions((TablePartition[])partitions);
        }
    }
}

