/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.LocalIndexPartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class LocalIndexPartitionTreeEditorPanel
extends AbstractPartitionTreeEditorPanel<IndexPartition, Index> {
    private static final String[] PROPERTIES = new String[]{PartitionProperty.INDEX_PARTITIONS, PartitionProperty.SUBPARTITIONS_FOR_INDEX_PARTITION};
    private ActionListener m_defPartitionsListener;
    private Collection<IndexPartition> m_partitions;
    private JCheckBox m_checkbox;

    LocalIndexPartitionTreeEditorPanel() {
        super("LocalIndexPartitionTreeEditorPanel");
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("INDEX_PARTITIONS_LIST_LABEL");
    }

    @Override
    protected ChildObjectEditorPanel<IndexPartition, Index> createChildPanel() {
        return new LocalIndexPartitionDetailsPanel();
    }

    @Override
    public void setDefinePartitionsCheckbox(JCheckBox chkDefinePartitions) {
        boolean showDefineCheckbox;
        Index index = (Index)this.getUpdatedObject();
        if (this.getProvider() instanceof Database) {
            Index originalIndex = (Index)TemporaryObjectID.findOriginalObject((DBObject)index);
            OracleIndexPartitions origOip = originalIndex == null ? null : (OracleIndexPartitions)originalIndex.getProperty("OracleIndexPartitions");
            showDefineCheckbox = origOip == null;
        } else {
            showDefineCheckbox = true;
        }
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        boolean hasIndexPartitions = oip.getPartitions().length > 0;
        Table parentTable = (Table)DBUtil.findParentOfType((DBObject)index, Table.class);
        OracleTablePartitions otp = (OracleTablePartitions)parentTable.getProperty("OracleTablePartitions");
        boolean hasTablePartitions = otp != null && (otp.getPartitions() != null && otp.getPartitions().length > 0 || otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH);
        chkDefinePartitions.setVisible(showDefineCheckbox);
        chkDefinePartitions.setEnabled(hasIndexPartitions || hasTablePartitions);
        chkDefinePartitions.setSelected(hasIndexPartitions);
        this.addActionListenerToDefineCheckbox(chkDefinePartitions);
        this.m_checkbox = chkDefinePartitions;
        super.setDefinePartitionsCheckbox(chkDefinePartitions);
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"name"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                DefaultMutableTreeNode current = TreeNodeMaker.findNode(LocalIndexPartitionTreeEditorPanel.this.getCurrentChild(), (DefaultMutableTreeNode)LocalIndexPartitionTreeEditorPanel.this.getTreeModel().getRoot());
                LocalIndexPartitionTreeEditorPanel.this.getTreeModel().nodeChanged(current);
            }
        };
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"OracleIndexPartitions"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                LocalIndexPartitionTreeEditorPanel.this.m_partitions = null;
            }
        };
    }

    private void addActionListenerToDefineCheckbox(JCheckBox defChk) {
        if (defChk != null) {
            defChk.removeActionListener(this.m_defPartitionsListener);
            defChk.addActionListener(this.m_defPartitionsListener);
        }
    }

    @Override
    protected void populateComponent() {
        OracleIndexPartitions oip = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        IndexPartition[] partitions = oip.getPartitions();
        if (partitions == null || partitions.length == 0) {
            partitions = this.getIndexPartitionsFromTablePartitions(false);
        }
        if (partitions != null) {
            for (IndexPartition partition : partitions) {
                this.addPartitionNode(partition);
            }
        }
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.m_defPartitionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox check = (JCheckBox)e.getSource();
                LocalIndexPartitionTreeEditorPanel.this.refreshIndexPartitionsTree(check.isSelected());
            }
        };
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        OracleIndexPartitions oip = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        if (oip.getPartitions().length == 0) {
            this.refreshIndexPartitionsTree(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.getDefinePartitionsCheckbox().removeActionListener(this.m_defPartitionsListener);
    }

    @Override
    protected Class<IndexPartition> getChildClass() {
        return IndexPartition.class;
    }

    @Override
    protected final String getChildProperty() {
        int level = this.getLevel();
        return level == -1 ? null : PROPERTIES[level];
    }

    @Override
    protected ListButtons createListButtons() {
        return new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeAddRemoveButtons() {
                return false;
            }

            @Override
            public boolean includeReorderButtons() {
                return false;
            }
        };
    }

    protected IndexPartition[] getChildren() {
        return this.getChildrenImpl(true);
    }

    private IndexPartition[] getChildrenImpl(boolean parentOfSelection) {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        DBObject selectedObject = (DBObject)sc.get(sel);
        Object parent = sel < 0 ? this.getUpdatedObject() : (parentOfSelection ? (DBObject)sc.getParent(selectedObject) : selectedObject);
        return this.getPartitions((DBObject)parent);
    }

    private IndexPartition[] getPartitions(DBObject parent) {
        SelectableComponent sc = this.getSelectableComponent();
        Object[] children = sc.getChildren(parent);
        int len = children == null ? 0 : children.length;
        IndexPartition[] partitions = new IndexPartition[]{};
        if (len > 0 && children[0] instanceof IndexPartition) {
            partitions = new IndexPartition[len];
            System.arraycopy(children, 0, partitions, 0, len);
        }
        return partitions;
    }

    @Override
    protected void commitChildPropertyImpl(boolean parentOfSelection) {
    }

    private DefaultMutableTreeNode addPartitionNode(IndexPartition partition) {
        DefaultTreeModel model = this.getTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(partition);
        root.insert(parent, root.getChildCount());
        IndexPartition[] subpartitions = (IndexPartition[])this.getPropertyHelper().getPropertyValue((Object)partition, PartitionProperty.INDEX_SUBPARTITIONS);
        this.addSubpartitionNodes(parent, subpartitions);
        int row = model.getIndexOfChild(root, parent);
        this.getTree().expandRow(row);
        model.nodesWereInserted(root, new int[]{row});
        return parent;
    }

    private void addSubpartitionNodes(DefaultMutableTreeNode parent, IndexPartition[] subpartitions) {
        if (subpartitions != null) {
            for (IndexPartition subpartition : subpartitions) {
                parent.insert(new DefaultMutableTreeNode(subpartition), parent.getChildCount());
            }
        }
    }

    private IndexPartition[] getIndexPartitionsFromTablePartitions(boolean refresh) {
        Table table = (Table)((Index)this.getUpdatedObject()).getParent();
        OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (refresh || this.m_partitions == null) {
            this.m_partitions = new ArrayList<IndexPartition>();
            if (otp != null) {
                Integer hashQuantity;
                TablePartition[] tps;
                for (TablePartition tp : tps = otp.getPartitions()) {
                    IndexPartition ip = LocalIndexPartitionHelper.createLocalIndexPartition((TablePartition)tp, (String)tp.getName());
                    this.m_partitions.add(ip);
                }
                if (tps.length == 0 && otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH && (hashQuantity = Integer.valueOf(otp.getHashQuantity() == null ? 1 : otp.getHashQuantity())) != null && hashQuantity > 0) {
                    for (int i = 1; i <= hashQuantity; ++i) {
                        IndexPartition ip = new IndexPartition("PARTITION" + i, null);
                        this.m_partitions.add(ip);
                    }
                }
            }
        }
        return this.m_partitions.toArray(new IndexPartition[this.m_partitions.size()]);
    }

    private void refreshIndexPartitionsTree(boolean define) {
        IndexPartition partitions;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        OracleIndexPartitions oip = (OracleIndexPartitions)((Index)this.getUpdatedObject()).getProperty("OracleIndexPartitions");
        int selIndx = this.getSelectableComponent().getSelectedIndex();
        if (define) {
            for (IndexPartition partition : partitions = this.getIndexPartitionsFromTablePartitions(false)) {
                oip.addPartition(partition);
                DefaultMutableTreeNode node = TreeNodeMaker.findNode(partition, root);
                node.setUserObject(partition);
                this.getTreeModel().nodeStructureChanged(node);
            }
            if (selIndx > -1) {
                IndexPartition selectedPartition = (IndexPartition)this.getSelectableComponent().get(selIndx);
                this.selectChild(selectedPartition);
                this.listSelectionChanged();
                this.getListButtons().enableButtons();
            }
        } else {
            root.removeAllChildren();
            this.getTreeModel().nodeStructureChanged(root);
            for (IndexPartition partition : partitions = this.getIndexPartitionsFromTablePartitions(true)) {
                this.addPartitionNode(partition);
            }
            oip.setPartitions(null);
            if (((IndexPartition[])partitions).length > 0 && selIndx > -1) {
                IndexPartition selectedPartition = (IndexPartition)this.getSelectableComponent().get(selIndx);
                this.selectChild(selectedPartition);
                this.listSelectionChanged();
            }
            TreeNodeMaker.expandAll(this.getTree());
        }
        LocalIndexPartitionDetailsPanel panel = (LocalIndexPartitionDetailsPanel)this.getChildPanel();
        panel.initialisePanel();
    }
}

