/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildListEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.table.LobColumnPropertiesPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.DisplayNames;

public class LobDescriptorsPanel
extends ChildListEditorPanel<LOBDescriptor, Table> {
    public LobDescriptorsPanel() {
        super("LobDescriptorsPanel");
        this.getComponentFactory().setBasePath(PartitionProperty.PARTITIONS);
        this.setHelpID("f1_odbtalobdescriptors_html");
    }

    @Override
    protected ChildObjectEditorPanel<LOBDescriptor, Table> createChildPanel() {
        return new DetailPanel();
    }

    @Override
    protected Class<LOBDescriptor> getChildClass() {
        return LOBDescriptor.class;
    }

    @Override
    protected String getChildProperty() {
        return "LOBDescriptors";
    }

    @Override
    protected String getListLabel() {
        return DisplayNames.getPropertyDisplayName((String)"LOBDescriptors");
    }

    @Override
    protected ChildSelectableComponentEditorPanel.DefaultButtonsHelper createButtonsHelper() {
        return new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public boolean includeReorderButtons() {
                return false;
            }

            @Override
            public boolean canAdd() {
                boolean retval = super.canAdd();
                retval = this.canAddAndRemove(retval);
                return retval;
            }

            @Override
            public boolean canRemove() {
                boolean retval = super.canRemove();
                retval = this.canAddAndRemove(retval);
                return retval;
            }

            private boolean canAddAndRemove(boolean retval) {
                LOBDescriptor lob;
                if (retval && LobDescriptorsPanel.this.getProvider() instanceof Database && (lob = (LOBDescriptor)LobDescriptorsPanel.this.getCurrentChild()) != null) {
                    retval = DBUtil.getOriginalID((DBObject)lob) == null;
                }
                return retval;
            }
        };
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new LOBDescriptorListRenderer();
    }

    private static final class DetailPanel
    extends ChildObjectEditorPanel<LOBDescriptor, Table> {
        DetailPanel() {
            super("LobDescriptorsPanel", PartitionProperty.LOB_DESCRIPTORS);
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            if (this.getChildObject() != null) {
                this.enableComponents();
            }
        }

        @Override
        protected void initialiseChildComponents() {
            super.initialiseChildComponents();
            DBUILayoutHelper lh = this.getDBUILayoutHelper();
            lh.setMargins(0);
            ComponentWrapper cw = this.getOrCreateWrapper("columns");
            lh.add(cw.getLabel(), 4, 1);
            lh.nextRow();
            lh.add(cw.getComponent(), 4, 1, true, true);
            lh.nextRow();
            LobColumnPropertiesPanel.initialiseLobComponents(this, (DBEditorConfig)this.getDataContext().find(DBEditorConfig.class), lh);
            lh.layout();
            cw.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newVal = evt.getNewValue();
                    if (newVal == null) {
                        this.enableName(0);
                    } else if (newVal instanceof DBObjectID[]) {
                        DBObjectID[] colIds = (DBObjectID[])newVal;
                        this.enableName(colIds.length);
                    }
                }
            });
        }

        private void enableComponents() {
            ComponentWrapper cwColumns = this.getOrCreateWrapper("columns");
            ComponentWrapper cwChunk = this.getOrCreateWrapper("chunk");
            ComponentWrapper cwStorageInRow = this.getOrCreateWrapper("storageInRow");
            boolean enabled = !(this.getProvider() instanceof Database) || this.getProvider() instanceof Database && this.getOriginalChildObject() == null;
            cwColumns.setVisible(enabled);
            cwChunk.setEnabled(enabled);
            cwStorageInRow.setEnabled(enabled);
            this.enableName(((LOBDescriptor)this.getChildObject()).getColumns().length);
        }

        private void enableName(int numCols) {
            ComponentWrapper cwSegName = this.getOrCreateWrapper("LOBSegName");
            boolean enabled = !(this.getProvider() instanceof Database) || this.getProvider() instanceof Database && this.getOriginalChildObject() == null;
            cwSegName.setEnabled(enabled && numCols <= 1);
            if (numCols > 1) {
                cwSegName.setPropertyValue(null);
            }
        }
    }

    private class LOBDescriptorListRenderer
    extends DBObjectRenderer {
        private LOBDescriptorListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel retval = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            LOBDescriptor lob = (LOBDescriptor)value;
            StringBuilder bob = new StringBuilder();
            if (lob.getColumns() != null) {
                boolean addComma = false;
                for (DBObjectID colID : lob.getColumns()) {
                    if (addComma) {
                        bob.append(", ");
                    }
                    bob.append(DBUtil.getDBObjectName((DBObjectID)colID));
                    addComma = true;
                }
            }
            retval.setText(bob.length() == 0 ? UIBundle.get("LOB_PARAM_NO_COLUMNS") : bob.toString());
            return retval;
        }
    }
}

