/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;

public abstract class AbstractPartitionTreeEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    private JTree m_tree;
    private JCheckBox m_chkDefinePartitions = new JCheckBox();

    public AbstractPartitionTreeEditorPanel(String panelName) {
        super(panelName);
    }

    public void setDefinePartitionsCheckbox(JCheckBox chkDefinePartitions) {
        this.m_chkDefinePartitions = chkDefinePartitions;
    }

    protected JCheckBox getDefinePartitionsCheckbox() {
        return this.m_chkDefinePartitions;
    }

    protected JTree getTree() {
        return this.m_tree;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        TreeNodeMaker.expandAll(this.m_tree);
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(this.getUpdatedObject()));
        this.m_tree = new JTree(model);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(DBValidationManager.wrapTreeCellRenderer(this.createItemRenderer(), this.getDataContext()));
        this.m_tree.setShowsRootHandles(true);
        return SelectableComponent.createSelectableComponent(this.m_tree);
    }

    @Override
    protected void commitChildProperty() {
        this.commitChildPropertyImpl(true);
    }

    @Override
    protected C findChild(C child, C[] partitions) {
        ChildDBObject retval;
        ChildDBObject parentPartition = (ChildDBObject)DBUtil.findParentOfType((DBObject)child.getParent(), child.getClass());
        if (parentPartition == null) {
            retval = super.findChild(child, partitions);
        } else {
            DefaultMutableTreeNode subPartitionNode;
            ChildDBObject subpartition = null;
            DefaultMutableTreeNode partitionNode = this.findChildNode(parentPartition, (DefaultMutableTreeNode)this.getTreeModel().getRoot());
            if (partitionNode != null && (subPartitionNode = this.findChildNode(child, partitionNode)) != null) {
                subpartition = (ChildDBObject)subPartitionNode.getUserObject();
            }
            retval = subpartition;
        }
        return (C)retval;
    }

    private DefaultMutableTreeNode findChildNode(C child, DefaultMutableTreeNode parNode) {
        DefaultMutableTreeNode realMatch = null;
        DefaultMutableTreeNode fuzzyMatch = null;
        Enumeration<TreeNode> enm = parNode.children();
        while (enm.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enm.nextElement();
            Object userObj = childNode.getUserObject();
            if (userObj == child) {
                realMatch = childNode;
                break;
            }
            if (fuzzyMatch != null || !(userObj instanceof DBObject) || !DBUtil.areNamesAndTypesEqual((DBObject)((DBObject)userObj), child)) continue;
            fuzzyMatch = childNode;
        }
        return realMatch == null ? fuzzyMatch : realMatch;
    }

    protected abstract void commitChildPropertyImpl(boolean var1);

    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    protected DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.m_tree.getModel();
    }

    protected int getLevel() {
        TreePath tp;
        int level = 0;
        if (this.m_tree != null && (tp = this.m_tree.getSelectionPath()) != null) {
            level = tp.getPathCount() - 2;
        }
        return level;
    }
}

