/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.MaterializedView;

public class MViewPanel
extends BaseEditorPanel<MaterializedView> {
    private static String[] PREBUILT_PROPS = new String[]{"cache", "buildType"};

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwCache = this.getOrCreateWrapper("cache");
        layout.add(cwCache);
        layout.nextRow();
        ComponentWrapper cwQueryRewrite = this.getOrCreateWrapper("queryRewrite");
        layout.add(cwQueryRewrite);
        layout.nextRow();
        ComponentWrapper cwPreBuilt = this.getOrCreateWrapper("onPrebuilt");
        layout.add(cwPreBuilt);
        layout.nextRow();
        ComponentWrapper cwBuildType = this.getOrCreateWrapper("buildType");
        layout.add(cwBuildType);
        layout.nextRow();
        ComponentWrapper cwDefaultIndex = this.getOrCreateWrapper("defaultIndex");
        layout.add(cwDefaultIndex);
        layout.nextRow();
        ComponentWrapper cwIndexStorageProps = this.isInFlatEditor() ? this.getOrCreateWrapper("MatViewIndexStorageProperties") : this.getOrCreateButtonWrapper("MatViewIndexStorageProperties");
        layout.add((Component)cwIndexStorageProps.getActiveComponent(), 2, 1);
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        MaterializedView mv = (MaterializedView)this.getUpdatedObject();
        this.enableIndexStorage(mv);
        this.enablePrebuilt(mv);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"defaultIndex", "onPrebuilt"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                if ("defaultIndex".equals(propertyName)) {
                    MViewPanel.this.enableIndexStorage((MaterializedView)obj);
                } else if ("onPrebuilt".equals(propertyName)) {
                    MViewPanel.this.enablePrebuilt((MaterializedView)obj);
                }
            }
        };
    }

    private void enableIndexStorage(MaterializedView mv) {
        boolean enable = mv == null ? false : Boolean.TRUE.equals(mv.getDefaultIndex());
        ComponentWrapper cwIndexStorageProps = this.getComponentFactory().findComponentWrapper("MatViewIndexStorageProperties");
        cwIndexStorageProps.setEnabled(enable);
    }

    private void enablePrebuilt(MaterializedView mv) {
        MaterializedView.PrebuiltType type = mv != null ? mv.getOnPrebuilt() : null;
        boolean enable = type == null || type == MaterializedView.PrebuiltType.NONE;
        for (String prop : PREBUILT_PROPS) {
            ComponentWrapper cw = this.getComponentFactory().findComponentWrapper(prop);
            cw.setEnabled(enable);
        }
    }
}

