/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.StatusIndicator;

public class DBTabbedPanel
extends TabbedPanel
implements DBTraversable {
    private StatusIndicator[] m_statusIndicators;
    private BaseEditorPanel m_baseEditorPanel;
    private DBValidationHandler m_validationHandler;
    private DBObject m_updatedObject;
    private boolean m_pendingStatusRefresh;

    public DBTabbedPanel(Navigable[] navigables) {
        super(navigables);
    }

    public DBTabbedPanel(Navigable[] navigables, TabbedPaneUI ui) {
        super(navigables, ui);
    }

    public void setBaseEditorPanel(BaseEditorPanel owner) {
        this.m_baseEditorPanel = owner;
    }

    public Navigable getCurrentNavigable() {
        return super.getCurrentNavigable();
    }

    public final Navigable[] getRootNavigables() {
        return super.getRootNavigables();
    }

    public int getSelectedIndex() {
        int retval = -1;
        Navigable curr = this.getCurrentNavigable();
        if (curr != null) {
            Navigable[] navs = this.getRootNavigables();
            for (int i = 0; i < navs.length; ++i) {
                if (curr != navs[i]) continue;
                retval = i;
                break;
            }
        }
        return retval;
    }

    public void setRootNavigables(Navigable[] rootNavigables) {
        super.setRootNavigables(rootNavigables);
        this.m_statusIndicators = null;
        this.m_pendingStatusRefresh = true;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Traversable t = this.getCurrentTraversable();
        return t instanceof DBTraversable ? ((DBTraversable)t).getDefaultFocusComponent() : null;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        Traversable t = this.getCurrentTraversable();
        return t instanceof DBTraversable ? ((DBTraversable)t).requestFocusForEditorConfig() : false;
    }

    public int findNavigableIndex(String property) {
        int retval = -1;
        String test = property;
        block0: while (test != null) {
            Navigable[] navs = this.getRootNavigables();
            for (int i = 0; i < navs.length; ++i) {
                if (!(navs[i] instanceof DBNavigable) || !((DBNavigable)navs[i]).isPanelProperty(test)) continue;
                retval = i;
                break block0;
            }
            test = Property.getParentProperty((String)test);
        }
        return retval;
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.m_pendingStatusRefresh = false;
        DBValidationHandler validationHandler = this.getOrCreateValidationHandler(tc);
        if (validationHandler != null) {
            this.m_updatedObject = this.getValidationUpdatedObject(tc);
            validationHandler.startValidation(this.getValidationOriginalObject(tc), this.m_updatedObject);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DBValidationHandler validationHandler = this.m_validationHandler;
        if (validationHandler != null) {
            validationHandler.stopValidation();
        }
        super.onExit(tc);
    }

    protected DBObject getValidationOriginalObject(TraversableContext tc) {
        DBObject retval;
        if (this.m_baseEditorPanel == null) {
            DBEditorConfig config = (DBEditorConfig)tc.find(DBEditorConfig.class);
            retval = config.getOriginalObject();
        } else {
            retval = this.m_baseEditorPanel.getComponentFactoryOriginalObject();
        }
        return retval;
    }

    protected DBObject getValidationUpdatedObject(TraversableContext tc) {
        DBObject retval;
        if (this.m_baseEditorPanel == null) {
            DBEditorConfig config = (DBEditorConfig)tc.find(DBEditorConfig.class);
            retval = config.getUpdatedObject();
        } else {
            retval = this.m_baseEditorPanel.getComponentFactoryUpdatedObject();
        }
        return retval;
    }

    private DBValidationHandler getOrCreateValidationHandler(TraversableContext data) {
        if (this.m_validationHandler == null) {
            DBEditorConfig config = (DBEditorConfig)data.find(DBEditorConfig.class);
            DBValidationManager mgr = (DBValidationManager)data.find(DBValidationManager.class);
            if (config != null && mgr != null) {
                this.m_validationHandler = mgr.createHandler(config, null);
                if (this.m_validationHandler != null) {
                    this.m_validationHandler.addListener((model, handler) -> this.updateStatusIndicators(model));
                }
            }
        }
        return this.m_validationHandler;
    }

    private void updateStatusIndicators(DBObjectValidationModel model) {
        if (this.getParent() != null && !this.m_pendingStatusRefresh) {
            Map map = model.getValidationMap(this.m_updatedObject);
            Navigable[] navs = this.getRootNavigables();
            if (this.m_statusIndicators == null) {
                this.m_statusIndicators = new StatusIndicator[navs.length];
            }
            for (int i = 0; i < this.m_statusIndicators.length; ++i) {
                Collection<String> panelProps;
                if (this.m_statusIndicators[i] == null) {
                    this.m_statusIndicators[i] = new StatusIndicator();
                }
                ArrayList<ValidationException> allErrs = new ArrayList<ValidationException>();
                if (map != null && navs[i] instanceof DBNavigable && (panelProps = ((DBNavigable)navs[i]).getProperties()) != null) {
                    for (String prop : panelProps) {
                        for (Map.Entry entry : map.entrySet()) {
                            String eprop = (String)entry.getKey();
                            if (eprop == null || !eprop.equals(prop) && !Property.startsWith((String)eprop, (String[])new String[]{prop})) continue;
                            allErrs.addAll((Collection)entry.getValue());
                        }
                    }
                }
                this.configureIndicator(this.m_statusIndicators[i], allErrs);
                this.setStatusIndicator(this.m_statusIndicators[i], i);
            }
        }
    }

    private void configureIndicator(StatusIndicator indicator, Collection<ValidationException> errors) {
        if (errors.isEmpty()) {
            indicator.setStatus(StatusIndicator.Status.OK);
            indicator.setInfoTipContent(null);
        } else {
            indicator.setStatus(StatusIndicator.Status.ERROR);
            indicator.setInfoTipContent(DBValidationManager.createInfoTipContent(errors));
        }
    }
}

