/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.ora.SQLQueryOwnerPanelLibrary;
import oracle.ideimpl.db.panels.CommentPanel;
import oracle.ideimpl.db.panels.view.ViewInfoPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.View;
import oracle.javatools.dialogs.MessageDialog;

public class ViewPanelLibrary
extends SQLQueryOwnerPanelLibrary<View> {
    public ViewPanelLibrary() {
        this((Map<String, String>)null);
    }

    protected ViewPanelLibrary(Map<String, String> helpIDs) {
        super("VIEW", helpIDs);
        this.addPanel(UIBundle.get("COMMENT"), CommentPanel.class, "f1_offlineviewprops_html", "Comment");
        this.addPanel(UIBundle.get("PROPERTIES"), ViewInfoPanel.class, "f1_offlineviewprops_html", "forceOnCreate", "restriction");
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_offlineview_html";
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_offlinedbview_html";
    }

    @Override
    protected List getTitles(View obj, DBObjectProvider pro, boolean editing) {
        List<String> retval = super.getTitles(obj, pro, editing);
        retval.add(UIBundle.get("PROPERTIES"));
        retval.add(UIBundle.get("COMMENT"));
        return retval;
    }

    @Override
    public boolean canReplaceByDefault() {
        return true;
    }

    @Override
    public void commitToProvider(DBEditorConfig config) {
        Constraint[] origCons;
        boolean commit = true;
        View orig = (View)config.getOriginalObject();
        if (orig != null && (origCons = orig.getConstraints()).length > 0) {
            View update = (View)config.getUpdatedObject();
            Column[] cols = update.getColumns();
            if (update.getConstraints().length != origCons.length && !MessageDialog.confirm((Component)DBMessageDialog.getDialogParent(), (Object)UIBundle.get("VIEW_WIZARD_CONSTRAINTS_LOST"), (String)this.getEditTitle(), null, (boolean)true)) {
                commit = false;
                config.setResult(DBEditorConfig.Result.CANCELLED);
            }
        }
        if (commit) {
            super.commitToProvider(config);
        }
    }
}

