/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectProviderNode;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.model.DatabaseNodeRecognizer;
import oracle.javatools.db.DBObject;

public abstract class ProviderNodeRecognizer<T> {
    public abstract String getProviderType(T var1);

    public abstract Object getProviderIdentifier(T var1);

    public abstract boolean isProviderNode(T var1);

    public DBObject getDBObject(T elem) {
        return elem instanceof DBObjectNode ? ((DBObjectNode)elem).getDBObject() : null;
    }

    public boolean isDBObjectNode(T elem) {
        return elem instanceof DBObjectNode;
    }

    public static <T> ProviderNodeRecognizer<T> findRecognizer(T elem) {
        ProviderNodeRecognizer retval = DatabaseNodeRecognizer.createRecognizer(elem);
        if (retval == null) {
            if (elem instanceof DBObjectProviderNode) {
                retval = new ProRecognizer();
            } else {
                DatabaseExtensionHook hook = DatabaseExtensionHook.getHook();
                if (hook != null) {
                    retval = hook.findNodeRecognizer(elem);
                }
            }
        }
        return retval;
    }

    private static class ProRecognizer
    extends ProviderNodeRecognizer<DBObjectProviderNode> {
        private ProRecognizer() {
        }

        @Override
        public Object getProviderIdentifier(DBObjectProviderNode elem) {
            return elem.getProviderIdentifier();
        }

        @Override
        public String getProviderType(DBObjectProviderNode elem) {
            return elem.getProviderType();
        }

        @Override
        public boolean isProviderNode(DBObjectProviderNode elem) {
            return !(elem instanceof DBObjectTypeNode);
        }
    }
}

