/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DropHelper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public class DatabaseDropHelper
implements DropHelper {
    public boolean canTransferData(Object dropTarget, DataFlavor[] transferFlavors, int action) {
        boolean canTransfer = DatabaseDropHelper.containsSystemObjectFlavor(transferFlavors);
        if (canTransfer) {
            Element data = DBObjectNodeUtil.getTreeNodeElement(dropTarget);
            String targetType = DBObjectNodeUtil.getProviderType(data);
            canTransfer = ModelUtil.hasLength((String)targetType);
        }
        return canTransfer;
    }

    public boolean transferData(Object dropTarget, Transferable[] transferablesForSelection, int action) {
        Element data;
        String targetType;
        boolean handled = false;
        String sourceType = null;
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        block5: for (Transferable transferable : transferablesForSelection) {
            for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                flavors.add(flavor);
                Class<?> repClass = flavor.getRepresentationClass();
                if (!DBObjectProvider.class.isAssignableFrom(repClass)) continue;
                DBObjectProvider pro = null;
                try {
                    pro = (DBObjectProvider)transferable.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException ufe) {
                    DBLog.logStackTrace((String)"Flavor not supported", (Throwable)ufe);
                    sourceType = null;
                    break block5;
                }
                catch (IOException ioe) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, ioe.getMessage());
                    sourceType = null;
                    break block5;
                }
                String thisType = pro.getProviderType();
                if (sourceType != null && !sourceType.equals(thisType)) {
                    sourceType = null;
                    break block5;
                }
                sourceType = thisType;
            }
        }
        if (sourceType != null && (targetType = DBObjectNodeUtil.getProviderType(data = DBObjectNodeUtil.getTreeNodeElement(dropTarget))) != null) {
            DataFlavor[] flavorArray = flavors.toArray(new DataFlavor[flavors.size()]);
            DatabaseUIExtensionHook hook = DatabaseUIExtensionHook.getHook();
            List<DropHelper> helpers = hook.getDropHelpers(sourceType, targetType);
            for (DropHelper dh : helpers) {
                if (dh == null) continue;
                try {
                    if (!handled && dh.canTransferData(dropTarget, flavorArray, action)) {
                        handled = dh.transferData(dropTarget, transferablesForSelection, action);
                    }
                }
                catch (Exception e) {
                    DBLog.logStackTrace((String)UIBundle.get("DRAG_AND_DROP_FAILED"), (Throwable)e);
                }
                DragDropManager mgr = DragDropManager.getInstance();
                mgr.unRegisterDropHelperForInstance(dh, Element.class);
                mgr.registerDropHelperForInstance(dh, Element.class);
            }
        }
        return handled;
    }

    public float getWeight() {
        return Float.MIN_VALUE;
    }

    public static boolean containsSystemObjectFlavor(DataFlavor[] transferFlavors) {
        boolean retval = false;
        for (DataFlavor flavor : transferFlavors) {
            Class<?> representationalClass = flavor.getRepresentationClass();
            if (!SystemObject.class.isAssignableFrom(representationalClass)) continue;
            retval = true;
            break;
        }
        return retval;
    }
}

