/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.util.dnd.DragHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class DatabaseDragHelper
implements DragHelper {
    private static final Map<String, DataFlavor> s_typeFlavor = new HashMap<String, DataFlavor>();
    private static final Map<String, DataFlavor> s_providerFlavor = new HashMap<String, DataFlavor>();

    private static DataFlavor findTypeDataFlavor(String type) {
        return s_typeFlavor.get(type);
    }

    private static DataFlavor findProviderDataFlavor(String type) {
        return s_providerFlavor.get(type);
    }

    private static DataFlavor[] getDataFlavors(String providerType, String type) {
        DataFlavor[] retval;
        Metadata metadata;
        Class representationClass;
        DataFlavor provFlavor = null;
        if (ModelUtil.hasLength((String)providerType) && (provFlavor = DatabaseDragHelper.findProviderDataFlavor(providerType)) == null) {
            provFlavor = new DataFlavor(DBObjectProvider.class, providerType);
            s_providerFlavor.put(providerType, provFlavor);
        }
        if ((representationClass = (metadata = Metadata.getInstance()).getObjectClass(type)) != null) {
            DataFlavor dboFlav = DatabaseDragHelper.findTypeDataFlavor(type);
            if (dboFlav == null) {
                dboFlav = new DataFlavor(representationClass, type);
                s_typeFlavor.put(type, dboFlav);
            }
            retval = provFlavor != null ? new DataFlavor[]{provFlavor, dboFlav} : new DataFlavor[]{dboFlav};
        } else {
            retval = new DataFlavor[]{};
        }
        return retval;
    }

    public Transferable getTransferable(Object userDataObject) {
        DBObjectTransferable retval = new DBObjectTransferable(userDataObject);
        return retval;
    }

    public class DBObjectTransferable
    implements Transferable {
        private Object m_data;

        private DBObjectTransferable(Object data) {
            this.m_data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] retval;
            if (this.m_data instanceof DBObjectTypeNode) {
                String type = DBObjectNodeUtil.normalizeType((DBObjectTypeNode)this.m_data);
                String providerType = DBObjectNodeUtil.getProviderType(this.m_data);
                retval = DatabaseDragHelper.getDataFlavors(providerType, type);
            } else {
                retval = new DataFlavor[]{};
            }
            return retval;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            Class<?> representationalClass = flavor.getRepresentationClass();
            boolean retval = DBObject.class.isAssignableFrom(representationalClass) || DBObjectProvider.class.isAssignableFrom(representationalClass);
            return retval;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            Object retval = null;
            if (this.isDataFlavorSupported(flavor)) {
                Class<?> representationalClass = flavor.getRepresentationClass();
                retval = DBObjectProvider.class.isAssignableFrom(representationalClass) ? DBObjectNodeUtil.findProvider(this.m_data) : DBObjectNodeUtil.getDBObject(this.m_data);
            } else {
                throw new UnsupportedFlavorException(flavor);
            }
            return retval;
        }
    }
}

