/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.hive.components.HivePartitionsComponentWrapper;
import oracle.ideimpl.db.hive.panels.HiveStoragePanel;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableTabPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.table.GenericTable;

public class HivePartitionsPanel
extends BaseChildrenEditorPanel<HivePartition, Table> {
    public HivePartitionsPanel() {
        super("HivePartitionsPanel");
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected ChildObjectEditorPanel createChildPanel() {
        return new BottomTabs();
    }

    @Override
    protected Class<HivePartition> getChildClass() {
        return HivePartition.class;
    }

    protected HivePartition[] getChildren() {
        HivePartitionsComponentWrapper hpcw = this.getTableWrapper();
        return (HivePartition[])((ComponentWrapper)hpcw).getPropertyValue();
    }

    @Override
    protected void selectChild(HivePartition child) {
        HivePartition currentChild = (HivePartition)this.getCurrentChild();
        if (currentChild != child && (currentChild == null || this.exitChildPanel())) {
            HivePartitionsComponentWrapper cw = this.getTableWrapper();
            int i = ((HivePartitionsComponentWrapper.HivePartitionsTable)cw.getExtendedTable()).indexOf(child);
            if (i >= 0) {
                GenericTable jt = ((HivePartitionsComponentWrapper.HivePartitionsTable)cw.getExtendedTable()).getTable();
                if (jt.getSelectedRow() != i) {
                    jt.getSelectionModel().setSelectionInterval(i, i);
                }
                this.enterChildPanel(child);
            }
            this.setCurrentChild(child);
            this.getChildPanel().setVisible(child != null);
        }
    }

    private HivePartitionsComponentWrapper getTableWrapper() {
        return (HivePartitionsComponentWrapper)this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
    }

    @Override
    protected void initialiseComponents() {
        HivePartitionsComponentWrapper pcw = this.getTableWrapper();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.setMarginBottom(0);
        String colsProp = Property.createPath((String[])new String[]{"HivePartitionProperties", "partitionColumns"});
        if (!this.isEditing() || this.getProvider().getPropertyManager().canAlterProperty((SystemObject)this.getOriginalObject(), (SystemObject)this.getUpdatedObject(), colsProp)) {
            ComponentWrapper ccw = this.getOrCreateWrapper(colsProp);
            ccw.addListener(evt -> this.columnsChanged(evt));
            Component colShuttle = ccw.getComponent();
            layout.add(colShuttle, 1, 1, true, this.isInFlatEditor());
            layout.nextRowWithGap();
            if (this.isInFlatEditor()) {
                colShuttle.setPreferredSize(new Dimension(200, 100));
            }
        }
        Component partsTab = pcw.getComponent();
        layout.add(partsTab, 1, 1, true, true);
        layout.nextRow();
        if (this.isInFlatEditor()) {
            partsTab.setPreferredSize(new Dimension(200, 100));
        }
        layout.add((Component)((Object)this.getChildPanel()), 1, 1, true, false);
        layout.layout();
        ((HivePartitionsComponentWrapper.HivePartitionsTable)pcw.getExtendedTable()).getTable().getSelectionModel().addListSelectionListener(e -> this.selectionChanged(e));
    }

    private void selectionChanged(ListSelectionEvent e) {
        if (this.isEntered() && !e.getValueIsAdjusting()) {
            HivePartitionsComponentWrapper.HivePartitionsTable t = (HivePartitionsComponentWrapper.HivePartitionsTable)this.getTableWrapper().getExtendedTable();
            HivePartition tp = t.getPartition(t.getTable().getSelectedRowInModel());
            this.selectChild(tp);
        }
    }

    private void columnsChanged(PropertyChangeEvent evt) {
        if (this.isEntered()) {
            this.commitCurrentWrapper();
            HivePartitionsPanel.columnsChanged(evt, this.getTableWrapper(), this.getComponentFactoryUpdatedObject());
        }
    }

    @Override
    protected void initialisePanel() {
        HivePartition[] parts;
        if (this.getCurrentChild() == null && (parts = this.getChildren()).length > 0) {
            this.selectChild(parts[0]);
        }
    }

    static void columnsChanged(PropertyChangeEvent evt, HivePartitionsComponentWrapper hpcw, DBObject currentlySelectedPartition) {
        DBObjectID[] newCols = (DBObjectID[])evt.getNewValue();
        if (newCols == null || newCols.length == 0) {
            hpcw.resetPropertyValue(null);
        } else {
            HivePropertyMetadata.refactorValues((PropertyChangeEvent)evt, (HivePartition[])((HivePartition[])hpcw.getPropertyValue()));
            hpcw.refreshObject(currentlySelectedPartition);
        }
    }

    public static class PartitionSerDePanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionSerDePanel() {
            super("PartitionSerDePanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            ComponentWrapper scw = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeClass"}));
            layout.add(scw);
            layout.pushUp();
            layout.layout();
        }
    }

    public static class PartitionFileFormatPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionFileFormatPanel() {
            super("PartitionFileFormatPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            ComponentWrapper pffcw = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "predefinedFileFormat"}));
            layout.add(pffcw);
            layout.nextRow();
            final ComponentWrapper incw = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}));
            layout.add(incw);
            layout.nextRow();
            final ComponentWrapper outcw = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"}));
            layout.add(outcw);
            layout.layout();
            pffcw.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (this.isEntered()) {
                        HiveStoragePanel.processPredefinedFormatChange(evt.getNewValue() != null, this.getOriginalObject(), this.getPropertyHelper(), incw, outcw);
                    }
                }
            });
        }
    }

    public static class PartitionLocationPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionLocationPanel() {
            super("PartitionLocationPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            layout.add(this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "hdfsLocation"})));
            layout.pushUp();
            layout.layout();
        }
    }

    public static class PartitionSpecPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        private JTextField m_specField = new JTextField();

        public PartitionSpecPanel() {
            super("PartitionSpecPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper layout = this.getDBUILayoutHelper();
            JLabel specLabel = new JLabel();
            this.getComponentFactory().getResourceHelper().resLabel(specLabel, this.m_specField, HiveUIBundle.get("SPECIFICATION"), "Spec");
            this.m_specField.setEditable(false);
            this.m_specField.setBorder(null);
            this.m_specField.setBackground(null);
            layout.add(specLabel);
            layout.add(this.m_specField);
            layout.pushUp();
            layout.layout();
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            this.refreshSpecLabel();
        }

        @Override
        protected boolean shouldValidateOnExit() {
            return false;
        }

        @Override
        protected DBObjectListener createComponentFactoryObjectListener() {
            return new SwingDBObjectPropertyListener(new String[]{"values"}){

                @Override
                protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                    this.refreshSpecLabel();
                }
            };
        }

        void refreshSpecLabel() {
            HivePartition tp = (HivePartition)this.getChildObject();
            this.m_specField.setText(tp == null ? "" : tp.getName());
        }
    }

    private static class BottomTabs
    extends ChildTableTabPanel<HivePartition, Table> {
        BottomTabs() {
            super("PartitionTabs", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}), 0);
        }

        @Override
        protected Collection<Navigable> getTabs() {
            ArrayList<Navigable> navs = new ArrayList<Navigable>();
            navs.add(this.createNavigable(HiveUIBundle.get("DETAILS"), PartitionSpecPanel.class, new String[0]));
            navs.add(this.createNavigable(DisplayNames.getPropertyDisplayName((String)"hdfsLocation"), PartitionLocationPanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "hdfsLocation"})));
            navs.add(this.createNavigable(HiveUIBundle.get("STORAGE_FORMAT"), PartitionFileFormatPanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "predefinedFileFormat"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"})));
            navs.add(this.createNavigable(HiveUIBundle.get("SERDE"), PartitionSerDePanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeClass"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeProperties"})));
            return navs;
        }

        @Override
        protected boolean shouldValidateOnExit() {
            return false;
        }
    }
}

