/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive;

import java.awt.Component;
import java.util.Collections;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ide.model.Element;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class HiveExternalTableController
implements Controller {
    private static final String COMMAND = "oracle.ide.db.hive.NewOracleExternalTable";

    public boolean handleEvent(IdeAction action, Context context) {
        boolean retval = false;
        if (this.isCommand(action)) {
            DBObject obj;
            retval = true;
            DBObjectNode node = HiveExternalTableController.getHiveTableNode(context);
            if (node != null && (obj = node.getDBObject()) instanceof Table) {
                DBObjectProvider hivePro = node.getProvider();
                DBObjectProviderPicker.PickerConfiguration pickerConfig = new DBObjectProviderPicker.PickerConfiguration();
                pickerConfig.setProviderTypes(hivePro.getProviderType());
                pickerConfig.setContext(context);
                pickerConfig.setDatabaseTypes("Oracle Database");
                pickerConfig.setPickerValidator(new DBObjectProviderPicker.PickerValidator(){

                    @Override
                    public void validateProvider(DBObjectProvider chosen) throws DBException {
                        DatabaseDescriptor desc;
                        boolean ok = false;
                        if (chosen != null && (desc = chosen.getDescriptor()).getDatabaseType().equals("Oracle Database") && desc.getDatabaseVersion() >= 12102) {
                            ok = true;
                        }
                        if (!ok) {
                            throw new DBException(null, HiveUIBundle.get("EXTTAB_ORA_TOO_OLD"));
                        }
                    }
                });
                DBObjectProvider oraPro = DBObjectProviderPicker.chooseProvider(pickerConfig, (Component)Ide.getMainWindow(), DBTypeDisplayRegistry.getDialogTitle("TABLE", false, false), HiveUIBundle.get("EXTTAB_CONN_TEXT"), null);
                if (oraPro != null) {
                    Table oraTab;
                    try {
                        oraTab = this.createOracleTable((Table)obj, hivePro, oraPro);
                    }
                    catch (CancelledException ce) {
                        oraTab = null;
                    }
                    catch (DBException dbe) {
                        DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), HiveUIBundle.get("EXTTAB_CONN_ERR_TITLE"), dbe);
                        oraTab = null;
                    }
                    if (oraTab != null) {
                        DBEditorConfig createConfig = DBEditorConfig.newCreateConfig(oraPro, (DBObject)oraTab);
                        createConfig.setChildObject((DBObject)oraTab.getColumns()[0]);
                        DBEditorFactory launcher = DBEditorFactoryRegistry.getCreateFactory(createConfig);
                        if (launcher != null) {
                            launcher.launchDialog(createConfig);
                        }
                    }
                }
            }
        }
        return retval;
    }

    public boolean update(IdeAction action, Context context) {
        boolean retval = false;
        if (this.isCommand(action)) {
            retval = true;
            action.setEnabled(HiveExternalTableController.getHiveTableNode(context) != null);
        }
        return retval;
    }

    private boolean isCommand(IdeAction action) {
        IdeAction reg = HiveExternalTableController.getAction();
        return reg != null && action.getCommandId() == reg.getCommandId();
    }

    private Table createOracleTable(Table hiveTable, DBObjectProvider hivePro, DBObjectProvider oraPro) throws DBException {
        SchemaObjectBuilder builder = new SchemaObjectBuilder(true);
        builder.setProperties("TABLE", "columns");
        builder.ensureObjectBuiltEx(new DBObject[]{hiveTable});
        String hiveTabName = hiveTable.getName();
        Schema schema = oraPro.getDefaultSchema();
        Table retval = new Table();
        retval.setSchema(schema);
        retval.setName(oraPro.getUniqueName("TABLE", (DBObject)schema, this.convertName(hiveTabName, "TABLE", hivePro, oraPro)));
        retval.setProperty("TableType", (Object)Table.TableType.EXTERNAL);
        DBObjectFactory fac = oraPro.getObjectFactory();
        OracleExternalTableProperties extProps = (OracleExternalTableProperties)fac.newObject(OracleExternalTableProperties.class, (DBObject)retval);
        retval.setProperty("OracleExternalTableProperties", (Object)extProps);
        extProps.setAccessDriverType("ORACLE_HIVE");
        BigDataAccessParameters params = (BigDataAccessParameters)fac.newObject(BigDataAccessParameters.class, (DBObject)extProps);
        BigDataAccessParameter tabParam = (BigDataAccessParameter)fac.newObject(BigDataAccessParameter.class, (DBObject)params);
        tabParam.setName("com.oracle.bigdata.tablename");
        tabParam.setParameterValue(DBUtil.getFullyQualifiedName((DBObject)hiveTable, (boolean)true));
        params.setBigDataAccessParameters(new BigDataAccessParameter[]{tabParam});
        extProps.setAccessParameters(params.getSQLText());
        extProps.setAccessParametersFragment((SQLFragment)params);
        Column[] hiveCols = hiveTable.getColumns();
        Column[] oraCols = new Column[hiveCols.length];
        for (int i = 0; i < hiveCols.length; ++i) {
            Column col = new Column();
            col.setName(this.convertName(hiveCols[i].getName(), "COLUMN", hivePro, oraPro));
            col.setDataTypeUsage(this.mapDTU(hiveCols[i].getDataTypeUsage(), oraPro));
            oraCols[i] = col;
        }
        retval.setColumns(oraCols);
        TemporaryObjectID.setID((DBObject)retval, (boolean)true);
        return retval;
    }

    private String convertName(String name, String type, DBObjectProvider source, DBObjectProvider target) {
        return target.getInternalName(source.getExternalName(name, type), type);
    }

    private DataTypeUsage mapDTU(DataTypeUsage hiveDTU, DBObjectProvider oraPro) {
        String typeName = null;
        Map attrs = null;
        String hiveType = DBUtil.getDBObjectName((DBObjectID)hiveDTU.getDataTypeID());
        if (ModelUtil.hasLength((String)hiveType)) {
            if ("DATE".equals(hiveType) || "TIMESTAMP".equals(hiveType)) {
                typeName = hiveType;
            } else if ("INT".equals(hiveType) || "SMALLINT".equals(hiveType) || "BIGINT".equals(hiveType) || "TINYINT".equals(hiveType) || "BOOLEAN".equals(hiveType) || "DECIMAL".equals(hiveType)) {
                typeName = "NUMBER";
            } else if ("BINARY".equals(hiveType)) {
                typeName = "RAW";
                attrs = Collections.singletonMap("size", 4000L);
            } else if ("FLOAT".equals(hiveType)) {
                typeName = "BINARY_FLOAT";
            } else if ("DOUBLE".equals(hiveType)) {
                typeName = "BINARY_DOUBLE";
            } else if ("VARCHAR".equals(hiveType)) {
                typeName = "VARCHAR2";
                attrs = hiveDTU.getAttributeValues();
            }
        }
        if (typeName == null) {
            typeName = "VARCHAR2";
            attrs = Collections.singletonMap("size", 4000L);
        }
        DataType type = oraPro.getDataType(typeName);
        return attrs == null ? type.createDefaultUsage() : type.createUsage(attrs);
    }

    static IdeAction getAction() {
        return IdeAction.find((String)COMMAND);
    }

    static DBObjectNode getHiveTableNode(Context context) {
        DBObjectProvider pro;
        String type;
        Element e;
        DBObjectNode retval = null;
        Element[] sel = context.getSelection();
        if (sel != null && sel.length == 1 && (e = sel[0]) instanceof DBObjectNode && "TABLE".equals(type = DBObjectNodeUtil.normalizeType(((DBObjectNode)e).getObjectType())) && (pro = DBObjectNodeUtil.findProvider(e)) != null && "Hive".equals(pro.getDescriptor().getDatabaseType())) {
            retval = (DBObjectNode)e;
        }
        return retval;
    }
}

