/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension.rules;

import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Element;
import oracle.ideimpl.db.extension.rules.AbstractRuleFunction;
import oracle.javatools.db.property.Metadata;

public class ContextHasSupportedDBObjectType
extends AbstractRuleFunction {
    public final boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        boolean retval = false;
        Context c = ruleContext.getIdeContext();
        Element e = c.getElement();
        if (e instanceof DBObjectTypeNode) {
            String objectType = DBObjectNodeUtil.normalizeType((DBObjectTypeNode)e);
            retval = this.isSupportedType(objectType);
        }
        return retval;
    }

    protected boolean isSupportedType(String objectType) {
        return Metadata.getInstance().getObjectClass(objectType) != null;
    }
}

