/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension.rules;

import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Element;
import oracle.ideimpl.db.extension.rules.AbstractRuleFunction;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.util.ModelUtil;

public final class ContextHasProvider
extends AbstractRuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        boolean retval = false;
        Context c = ruleContext.getIdeContext();
        Element e = c.getElement();
        String proType = this.getParameterValue("provider-type", parameters);
        if (proType == null || ModelUtil.areEqual((Object)proType, (Object)DBObjectNodeUtil.getProviderType(e))) {
            String dbType = this.getParameterValue("database-type", parameters);
            String verStr = this.getParameterValue("database-version", parameters);
            if (proType != null && dbType == null && verStr == null) {
                retval = true;
            } else {
                DBObjectProvider pro = DBObjectNodeUtil.findProvider(e);
                if (pro != null && (dbType == null || ModelUtil.areEqual((Object)dbType, (Object)pro.getDescriptor().getDatabaseType()))) {
                    int dbVer = -1;
                    if (ModelUtil.hasLength((String)verStr)) {
                        try {
                            dbVer = Integer.valueOf(verStr);
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuleEvaluationException(nfe.getMessage());
                        }
                    }
                    if (dbVer == -1 || dbVer == pro.getDescriptor().getDatabaseVersion()) {
                        retval = true;
                    }
                }
            }
        }
        return retval;
    }
}

