/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension.rules;

import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Element;
import oracle.ideimpl.db.extension.rules.AbstractRuleFunction;

public class ContextHasDBObjectType
extends AbstractRuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        boolean retval = false;
        Context c = ruleContext.getIdeContext();
        Element e = c.getElement();
        if (e instanceof DBObjectTypeNode) {
            boolean isObject = e instanceof DBObjectNode;
            String restrictTo = this.getParameterValue("restrict-to", parameters);
            if (restrictTo == null || restrictTo.equals("OBJECT") && isObject || restrictTo.equals("FOLDER") && !isObject) {
                String[] requiredTypes;
                String nodeType = DBObjectNodeUtil.normalizeType((DBObjectTypeNode)e);
                String requiredTypesString = this.getRequiredParameterValue("object-types", parameters);
                for (String type : requiredTypes = requiredTypesString.split(",")) {
                    if (!type.trim().equals(nodeType)) continue;
                    retval = true;
                    break;
                }
            }
        }
        return retval;
    }
}

