/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.util.dnd.DropHelper;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.ideimpl.db.jdbc.JdbcDBEditorFactory;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class DatabaseUIExtensionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-ui-hook";
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-ui-hook");
    private final Map<String, EditorFactoryHash> m_edFacHashesByClz = new ConcurrentHashMap<String, EditorFactoryHash>();
    private final Map<String, EditorFactoryHash> m_edFacHashesByDBType = new ConcurrentHashMap<String, EditorFactoryHash>();
    private final Map<String, EditorFactoryHash> m_edFacHashesByProType = new ConcurrentHashMap<String, EditorFactoryHash>();
    private DBEditorFactory m_jdbcEdFac;
    private final MultiMap<String, ComponentWrapperHash> m_cwHashes = new MultiMap(CopyOnWriteArrayList.class);
    private final Map<String, TesterComponentHash> m_testerComponents = new ConcurrentHashMap<String, TesterComponentHash>();
    private final List<ProviderPickerHash> m_providerPickers = new CopyOnWriteArrayList<ProviderPickerHash>();
    private final MultiMap<String, DropHelperHash> m_dropHelpers = MultiMap.getMultiMap(ConcurrentHashMap.class, ArrayList.class);
    private HashStructure m_dbExecutorHash;
    private HashStructure m_typeFilterHash;

    @Override
    protected void processHashStructure(HashStructure hash) {
        Object filterHash;
        super.processHashStructure(hash);
        for (HashStructure edFacHash : this.getChildList(hash, "object-editor-factories", "object-editor-factory")) {
            String proType;
            String dbType;
            EditorFactoryHash efh = new EditorFactoryHash(edFacHash);
            String name = efh.getProviderClassName();
            if (ModelUtil.hasLength((String)name)) {
                this.logWarning(edFacHash, "Specfying provider-class for object-editor-factory registration is deprecated, use database-type");
                this.m_edFacHashesByClz.put(name, efh);
            }
            if (ModelUtil.hasLength((String)(dbType = efh.getDatabaseType()))) {
                this.m_edFacHashesByDBType.put(dbType, efh);
            }
            if (!ModelUtil.hasLength((String)(proType = efh.getProviderType()))) continue;
            this.m_edFacHashesByProType.put(proType, efh);
        }
        for (HashStructure cwHash : this.getChildList(hash, "component-wrappers", "component-wrapper")) {
            ComponentWrapperHash cw = new ComponentWrapperHash(cwHash);
            for (String prop : cw.getPropertyNames()) {
                this.m_cwHashes.add((Object)prop, (Object)cw);
            }
        }
        for (HashStructure testerHash : this.getChildList(hash, "sql-tester-components", "sql-tester-component")) {
            TesterComponentHash tch = new TesterComponentHash(testerHash);
            String id = tch.getID();
            if (ModelUtil.hasLength((String)id)) {
                this.m_testerComponents.put(id, tch);
                continue;
            }
            this.logMissingElemError(testerHash, "id");
        }
        for (HashStructure pickerHash : this.getChildList(hash, "provider-pickers", "provider-picker")) {
            ProviderPickerHash pphash = new ProviderPickerHash(pickerHash);
            this.m_providerPickers.add(0, pphash);
        }
        for (HashStructure dropHelperHash : this.getChildList(hash, "drop-helpers", "drop-helper")) {
            DropHelperHash dhh = new DropHelperHash(dropHelperHash);
            String key = dhh.getSourceTargetKey();
            if (key == null) continue;
            this.m_dropHelpers.add((Object)key, (Object)dhh);
        }
        Object executorHash = hash.getObject("db-executor");
        if (executorHash instanceof HashStructure && ModelUtil.hasLength((String)HashStructureHook.getText((HashStructure)((HashStructure)executorHash)))) {
            if (this.m_dbExecutorHash != null) {
                this.logWarning(this.m_dbExecutorHash, "db-executor replaced by downstream extension");
            }
            this.m_dbExecutorHash = (HashStructure)executorHash;
        }
        if ((filterHash = hash.getObject("default-object-type-filter")) instanceof HashStructure) {
            if (this.m_typeFilterHash != null) {
                this.logWarning(this.m_typeFilterHash, "default-object-type-filter replaced by downstream extension");
            }
            this.m_typeFilterHash = (HashStructure)filterHash;
        }
    }

    public DBEditorFactory findEditorFactory(DBObjectProvider pro) {
        DBEditorFactory retval = null;
        if (pro instanceof Database) {
            retval = this.findEditorFactory(pro.getClass());
            if (retval == null) {
                retval = this.findDatabaseEditorFactory(pro.getDescriptor());
            }
        } else {
            this.checkListenerInit();
            EditorFactoryHash efh = this.m_edFacHashesByProType.get(pro.getProviderType());
            if (efh != null) {
                retval = efh.getEditorFactory();
            }
        }
        return retval;
    }

    public DBEditorFactory findDatabaseEditorFactory(DatabaseDescriptor desc) {
        this.checkListenerInit();
        DBEditorFactory retval = null;
        EditorFactoryHash efh = this.m_edFacHashesByDBType.get(desc.getDatabaseType());
        if (efh != null) {
            retval = efh.getEditorFactory();
        }
        if (retval == null && (retval = this.m_jdbcEdFac) == null) {
            this.m_jdbcEdFac = retval = new JdbcDBEditorFactory();
        }
        return retval;
    }

    @Deprecated
    public DBEditorFactory findEditorFactory(Class<? extends DBObjectProvider> c) {
        DBEditorFactory retval = null;
        block0: for (Class<? extends DBObjectProvider> testClz = c; testClz != null && (retval = this.getEditorFactory(testClz)) == null; testClz = testClz.getSuperclass()) {
            for (Class<?> clz : testClz.getInterfaces()) {
                retval = this.getEditorFactory(clz);
                if (retval != null) break block0;
            }
        }
        return retval;
    }

    private DBEditorFactory getEditorFactory(Class c) {
        this.checkListenerInit();
        DBEditorFactory retval = null;
        EditorFactoryHash efh = this.m_edFacHashesByClz.get(c.getName());
        if (efh != null) {
            retval = efh.getEditorFactory();
        }
        return retval;
    }

    public Map<String, Collection<ComponentWrapperHash>> getComponentWrappers() {
        return Collections.unmodifiableMap(this.m_cwHashes);
    }

    public ComponentWrapper createComponentWrapper(ComponentContext context) {
        ComponentWrapper retval;
        block2: {
            ComponentWrapperHash hash;
            this.checkListenerInit();
            retval = null;
            String propName = context.getPropertyName();
            String strippedPropName = Property.getLastProperty((String)propName);
            Collection wrappers = this.m_cwHashes.get((Object)propName);
            if (wrappers == null && !propName.equals(strippedPropName)) {
                wrappers = this.m_cwHashes.get((Object)strippedPropName);
            }
            if (wrappers == null || wrappers.isEmpty()) break block2;
            ListIterator iter = ((List)wrappers).listIterator(wrappers.size());
            while (iter.hasPrevious() && (!(hash = (ComponentWrapperHash)((Object)iter.previous())).isCompatibleContext(context, propName, strippedPropName) || (retval = hash.createWrapper(context)) == null)) {
            }
        }
        return retval;
    }

    public Collection<String> getSQLTesterComponentIDs() {
        this.checkListenerInit();
        return new TreeSet<String>(this.m_testerComponents.keySet());
    }

    public TesterComponent getSQLTesterComponent(String id) {
        this.checkListenerInit();
        return this.m_testerComponents.get(id);
    }

    public Iterable<ProviderPickerHash> getDBObjectProviderPickers() {
        this.checkListenerInit();
        return this.m_providerPickers;
    }

    public List<DropHelper> getDropHelpers(String sourceType, String targetType) {
        this.checkListenerInit();
        String key = DatabaseUIExtensionHook.createDropHelperKey(sourceType, targetType);
        List hashes = (List)this.m_dropHelpers.get((Object)key);
        ArrayList orderedHashes = new ArrayList();
        orderedHashes.addAll(hashes);
        Collections.sort(orderedHashes, (dhh1, dhh2) -> DatabaseUIExtensionHook.compareDropHelperHash(dhh1, dhh2));
        ArrayList<DropHelper> helpers = new ArrayList<DropHelper>();
        for (DropHelperHash dhh : orderedHashes) {
            DropHelper helper = dhh.getDropHelper();
            if (helper == null) continue;
            helpers.add(helper);
        }
        return helpers;
    }

    public ExecutorService getDBExecutor() {
        this.checkListenerInit();
        HashStructure execHash = this.m_dbExecutorHash;
        ExecutorService retval = null;
        if (execHash != null) {
            try {
                MetaClass mc = this.getMetaClass(execHash);
                retval = (ExecutorService)mc.newInstance();
            }
            catch (Exception e) {
                this.logError(execHash, e.getMessage());
            }
        }
        return retval;
    }

    public Collection<String> getDefaultObjectTypeFilter() {
        this.checkListenerInit();
        TreeSet<String> retval = new TreeSet<String>();
        HashStructure filterHash = this.m_typeFilterHash;
        if (filterHash != null) {
            for (HashStructure kid : filterHash.getAsList("object-type")) {
                String type = HashStructureHook.getText((HashStructure)kid);
                retval.add(type);
            }
        }
        return retval;
    }

    public static DatabaseUIExtensionHook getHook() {
        return DatabaseUIExtensionHook.findHook(NAME, DatabaseUIExtensionHook.class);
    }

    private static int compareDropHelperHash(DropHelperHash dhh1, DropHelperHash dhh2) {
        float weight2;
        float weight1 = dhh1.getWeight();
        int compare = weight1 == (weight2 = dhh2.getWeight()) ? 0 : (weight1 > weight2 ? -1 : 1);
        return compare;
    }

    private static String createDropHelperKey(String source, String target) {
        StringBuilder builder = new StringBuilder();
        builder.append(source);
        builder.append(" -> ");
        builder.append(target);
        return builder.toString();
    }

    private final class DropHelperHash
    extends HashStructureAdapter {
        private DropHelperHash(HashStructure hash) {
            super(hash);
        }

        private String getSourceTargetKey() {
            String key;
            String source = this._hash.getString("source");
            String target = this._hash.getString("target");
            if (ModelUtil.hasLength((String)source) && ModelUtil.hasLength((String)target)) {
                key = DatabaseUIExtensionHook.createDropHelperKey(source, target);
            } else {
                String elemName = ModelUtil.hasLength((String)source) ? "target" : "source";
                key = null;
                DatabaseUIExtensionHook.this.logMissingElemError(this._hash, elemName);
            }
            return key;
        }

        private float getWeight() {
            return this._hash.getFloat("weight");
        }

        private DropHelper getDropHelper() {
            HashStructure hchs = this._hash.getHashStructure("helper-class");
            return DatabaseUIExtensionHook.this.instantiateClass(hchs, DropHelper.class);
        }
    }

    public class ProviderPickerHash
    extends HashStructureAdapter {
        public ProviderPickerHash(HashStructure hash) {
            super(hash);
        }

        public String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }

        public DBObjectProviderPicker getProviderPicker() {
            DBObjectProviderPicker providerPicker = null;
            HashStructure factoryHash = this._hash.getHashStructure("picker-class");
            if (factoryHash != null) {
                providerPicker = DatabaseUIExtensionHook.this.instantiateClass(factoryHash, DBObjectProviderPicker.class);
            }
            return providerPicker;
        }

        public String getLabel() {
            return this._hash.getString("label/#text");
        }
    }

    public class TesterComponentHash
    extends TesterComponent.DelegateTesterComponent {
        private final HashStructure m_hash;

        TesterComponentHash(HashStructure hash) {
            this.m_hash = hash;
        }

        @Override
        protected TesterComponent createDelegate() {
            TesterComponent retval = null;
            HashStructure clzHash = this.m_hash.getHashStructure("class");
            if (clzHash != null) {
                retval = DatabaseUIExtensionHook.this.instantiateClass(clzHash, TesterComponent.class);
            }
            return retval;
        }

        @Override
        public String getName() {
            return DatabaseUIExtensionHook.this.getText(this.m_hash, "display-name");
        }

        public String getID() {
            return DatabaseUIExtensionHook.this.getText(this.m_hash, "id");
        }
    }

    public class EditorFactoryHash
    extends HashStructureAdapter {
        private DBEditorFactory m_edFac;

        public EditorFactoryHash(HashStructure hash) {
            super(hash);
        }

        public String getProviderClassName() {
            return this._hash.getString("provider-class/#text");
        }

        public String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }

        public String getDatabaseType() {
            return this._hash.getString("database-type/#text");
        }

        public DBEditorFactory getEditorFactory() {
            HashStructure factoryHash;
            if (this.m_edFac == null && (factoryHash = this._hash.getHashStructure("factory-class")) != null) {
                this.m_edFac = DatabaseUIExtensionHook.this.instantiateClass(factoryHash, DBEditorFactory.class);
            }
            return this.m_edFac;
        }
    }

    public class ComponentWrapperHash
    extends HashStructureAdapter {
        private static final String PANEL_CLASS = "panel-class";
        private static final String WRAPPER_CLASS = "wrapper-class";

        public ComponentWrapperHash(HashStructure hash) {
            super(hash);
        }

        public Collection<String> getPropertyNames() {
            ArrayList<String> retval = new ArrayList<String>();
            for (HashStructure nameHash : this._hash.getAsList("property-name")) {
                retval.add(HashStructureHook.getText((HashStructure)nameHash));
            }
            return retval;
        }

        public ComponentWrapper createWrapper(ComponentContext context) {
            ComponentWrapper<Object> retval = null;
            HashStructure panelHash = this._hash.getHashStructure(PANEL_CLASS);
            if (panelHash != null) {
                BaseEditorPanel panel = DatabaseUIExtensionHook.this.instantiateClass(panelHash, BaseEditorPanel.class);
                if (panel != null) {
                    retval = context != null && context.isButtonContext() ? panel.createButtonWrapper() : panel.createPanelWrapper();
                }
            } else {
                HashStructure wrapperHash = this._hash.getHashStructure(WRAPPER_CLASS);
                if (wrapperHash != null) {
                    Class<ComponentWrapper> clz = DatabaseUIExtensionHook.this.loadClass(wrapperHash, ComponentWrapper.class);
                    try {
                        Constructor<ComponentWrapper> ctr = clz.getConstructor(String.class);
                        retval = ctr.newInstance(context.getPropertyName());
                    }
                    catch (Exception e) {
                        retval = DatabaseUIExtensionHook.this.instantiateClass(wrapperHash, ComponentWrapper.class);
                    }
                } else {
                    DatabaseUIExtensionHook.this.logMissingElemsError(wrapperHash, null, PANEL_CLASS, WRAPPER_CLASS);
                    if (context == null) {
                        throw new IllegalStateException("Missing panel-class or wrapper-class");
                    }
                }
            }
            return retval;
        }

        public boolean isCompatibleContext(ComponentContext context, String propName, String strippedPropName) {
            PropertyInfo par;
            Class<?> objClz;
            String className;
            boolean retval = true;
            DBObjectProvider pro = context.getProvider();
            DBObject updatedObject = context.getUpdatedObject();
            if (updatedObject != null && (className = this.getObjectClassName()) != null && !(retval = DatabaseUIExtensionHook.this.isAssignableFrom(className, objClz = updatedObject.getClass())) && !propName.equals(strippedPropName) && pro != null && (par = pro.getPropertyManager().findPropertyInfo(objClz, Property.getParentProperty((String)propName))) != null) {
                retval = DatabaseUIExtensionHook.this.isAssignableFrom(className, par.getPropertyClass());
            }
            if (retval && pro != null) {
                String dbType;
                String proType = this.getProviderType();
                if (proType != null) {
                    retval = proType.equals(pro.getProviderType());
                }
                if (retval && (dbType = this.getDatabaseType()) != null) {
                    retval = dbType.equals(pro.getDescriptor().getDatabaseType());
                }
            }
            return retval;
        }

        private String getObjectClassName() {
            return this._hash.getString("object-class/#text");
        }

        public Class<? extends DBObject> getObjectClass() {
            return DatabaseUIExtensionHook.this.loadClass(this._hash, "object-class", DBObject.class);
        }

        private String getDatabaseType() {
            return this._hash.getString("database-type/#text");
        }

        private String getProviderType() {
            return this._hash.getString("provider-type/#text");
        }
    }
}

