/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;

public final class DBObjectNavigationPoint
extends DefaultNavigationPoint {
    private DBObject m_childObject;
    private String m_property;

    protected int navigateImpl() throws Exception {
        return super.navigateImpl();
    }

    protected int renavigate() throws Exception {
        int retval = 1;
        if (this.m_childObject == null && this.viewID != null) {
            retval = super.renavigate();
        } else if (this.nodeURL != null) {
            DBEditorFactory factory;
            Node node;
            Context context = this.getContext();
            Workspace ws = context.getWorkspace();
            if (ws != null) {
                Ide.setActiveWorkspace((Workspace)ws);
                Ide.setActiveProject((Project)context.getProject());
            }
            if ((node = NodeFactory.find((URL)this.nodeURL)) instanceof DBObjectNode && (factory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)node)) != null) {
                DBEditorConfig config = DBEditorConfig.newEditConfig((DBObjectNode)node);
                config.setChildObject(this.m_childObject);
                config.setProperty(this.m_property);
                factory.launchDialog(config);
                retval = 0;
            }
        }
        return retval;
    }

    public void setContext(Context context) {
        super.setContext(context);
        DBObject child = null;
        String property = null;
        DBEditorConfig config = DBEditorConfig.getConfig(context);
        if (config != null) {
            property = config.getProperty();
            DBObject configChild = config.getChildObject();
            if (configChild != null) {
                DBObject orig = TemporaryObjectID.findOriginalObject((DBObject)configChild);
                child = orig == null ? configChild : orig;
            }
        }
        this.m_childObject = child;
        this.m_property = property;
    }

    public Object copyTo(Object target) {
        DBObjectNavigationPoint copy = target == null ? new DBObjectNavigationPoint() : (DBObjectNavigationPoint)((Object)target);
        super.copyToImpl((DefaultNavigationPoint)copy);
        copy.m_childObject = this.m_childObject;
        copy.m_property = this.m_property;
        return copy;
    }

    public String getShortLabel() {
        return this.m_childObject == null ? super.getShortLabel() : DBUtil.getFullyQualifiedName((DBObject)this.m_childObject, (boolean)false);
    }

    public Icon getIcon() {
        return this.m_childObject == null ? super.getIcon() : DBTypeDisplayRegistry.getNodeIcon(this.m_childObject);
    }
}

