/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.dialogs;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressBar;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.Holder;

public class DBUIProgressBar {
    private static final int DELAY = 5000;
    private static final int WC_DELAY = 1000;
    private final String m_title;
    private boolean m_cancellable = true;
    private ProgressBar m_pbar;
    private String m_baseDialogName;

    public DBUIProgressBar(String title) {
        this.m_title = title;
    }

    public void setDialogName(String baseDialogName) {
        this.m_baseDialogName = baseDialogName;
    }

    public void setCancellable(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    public void execute(Runnable run) {
        this.execute(run, null, null);
    }

    public <T, E extends Throwable> T execute(ProgressCallable<T, E> c) throws E {
        return this.execute(c, null, null);
    }

    public <T, E extends Throwable> T execute(final ProgressCallable<T, E> c, String initialText, String stepText) throws E {
        final Holder retval = new Holder();
        final Holder caught = new Holder();
        Runnable proxy = new Runnable(){

            @Override
            public void run() {
                try {
                    retval.set(c.call());
                }
                catch (Throwable t) {
                    caught.set((Object)t);
                }
            }
        };
        this.execute(proxy, initialText, stepText);
        Throwable t = (Throwable)caught.get();
        if (t != null) {
            throw t;
        }
        return (T)retval.get();
    }

    public void execute(final Runnable run, String initialText, String stepText) {
        if (DBMessageDialog.useDialog() && SwingUtilities.isEventDispatchThread()) {
            if (this.m_pbar != null) {
                throw new IllegalStateException("A DBUIProgressBar cannot be executed twice");
            }
            final ProgressBar pbar = new ProgressBar(DBMessageDialog.getDialogParent(), this.m_title, null, true);
            Runnable proxy = new Runnable(){

                @Override
                public void run() {
                    try {
                        run.run();
                    }
                    catch (Throwable t) {
                        if (!pbar.hasUserCancelled()) {
                            DBLog.getLogger((Object)run).log(Level.SEVERE, t.getMessage(), t);
                        }
                    }
                    finally {
                        DBUIProgressBar.this.m_pbar.setDoneStatus();
                    }
                }
            };
            String dialogBaseName = this.m_baseDialogName == null ? "DBUIProgressBar" : this.m_baseDialogName;
            pbar.setDialogName(dialogBaseName + ":" + DBUtil.createUUID());
            pbar.setRunnable(proxy);
            pbar.setCancelable(this.m_cancellable);
            this.m_pbar = pbar;
            DBUIProgressBar.start(pbar, initialText, stepText);
        } else {
            run.run();
        }
    }

    public boolean hasUserCancelled() {
        return this.m_pbar != null && this.m_pbar.hasUserCancelled();
    }

    public static void start(ProgressBar pbar, String initialText, String stepText) {
        pbar.start(initialText, stepText, 0, 100, 1000, 5000);
    }

    public static abstract class ProgressCallable<T, E extends Throwable> {
        public abstract T call() throws E;
    }
}

