/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class MVRefreshDateExpressionPanel
extends JPanel {
    private static final String SYSDATE = "SYSDATE";
    private static final String SYSDATE_PLUS_1 = "SYSDATE + 1";
    private static final String SYSDATE_PLUS_124 = "SYSDATE + 1/24";
    private final PlSqlTokenPattern m_sysdateSearch = new PlSqlTokenPattern("SYSDATE");
    private final PlSqlTokenPattern m_dailySearch = new PlSqlTokenPattern("SYSDATE + 1");
    private final PlSqlTokenPattern m_hourlySearch = new PlSqlTokenPattern("SYSDATE + 1/24");
    private final PlSqlTokenPattern m_dateSearch = new PlSqlTokenPattern(this.getToDateString("<d ?>"));
    private final JComboBox m_mode = new JComboBox();
    private final DateEditor m_datePicker;
    private final JTextField m_text;

    public MVRefreshDateExpressionPanel() {
        this.m_mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVRefreshDateExpressionPanel.this.enableControls();
                MVRefreshDateExpressionPanel.this.updateText();
            }
        });
        this.m_datePicker = new DateEditor();
        this.m_text = new JTextField();
        this.m_datePicker.setDateFormat((DateFormat)new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss"));
        this.m_datePicker.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MVRefreshDateExpressionPanel.this.updateText();
            }
        });
        DBUILayoutHelper helper = new DBUILayoutHelper(this);
        helper.setMargins(0);
        helper.add(this.m_mode, 1, 1, false, false);
        helper.add((Component)this.m_datePicker, 1, 1, true, false);
        helper.add(this.m_text, 1, 1, true, false);
        helper.layout();
    }

    public void initialiseComponent(ComponentContext context) {
        this.m_mode.addItem(ComboItem.UNSPECIFED);
        if ("firstRefresh".equals(context.getPropertyName())) {
            this.m_mode.addItem(ComboItem.SYSDATE);
        } else {
            this.m_mode.addItem(ComboItem.DAILY);
            this.m_mode.addItem(ComboItem.HOURLY);
        }
        this.m_mode.addItem(ComboItem.DATE);
        this.m_mode.addItem(ComboItem.EXPRESSION);
        this.m_mode.setSelectedIndex(0);
    }

    public void setValue(String value) {
        this.m_text.setText(value);
        if (value == null) {
            this.m_mode.setSelectedItem((Object)ComboItem.UNSPECIFED);
        } else {
            PlSqlToken tk;
            PlSqlToken tk2 = tk = PlSqlTokenizer.tokenize((String)value, (String[])new String[0]);
            while (tk2.getNextCodeToken() != null && ((PlSqlToken)tk2.getNextCodeToken()).getType() != Token.Type.END_MARKER) {
                tk2 = (PlSqlToken)tk2.getNextCodeToken();
            }
            TokenPattern.PatternResult sysdateMR = this.m_sysdateSearch.getResult((Token)tk);
            TokenPattern.PatternResult dailyMR = this.m_dailySearch.getResult((Token)tk);
            TokenPattern.PatternResult hourlyMR = this.m_hourlySearch.getResult((Token)tk);
            TokenPattern.PatternResult dateMR = this.m_dateSearch.getResult((Token)tk);
            if (sysdateMR != null && sysdateMR.getEndToken() == tk2) {
                this.m_mode.setSelectedItem((Object)ComboItem.SYSDATE);
            } else if (dailyMR != null && dailyMR.getEndToken() == tk2) {
                this.m_mode.setSelectedItem((Object)ComboItem.DAILY);
            } else if (hourlyMR != null && hourlyMR.getEndToken() == tk2) {
                this.m_mode.setSelectedItem((Object)ComboItem.HOURLY);
            } else {
                String d;
                boolean found = false;
                if (dateMR != null && dateMR.getEndToken() == tk2 && (d = dateMR.getNamedMatch("d")).startsWith("'") && d.endsWith("'")) {
                    d = d.substring(1, d.length() - 1);
                    try {
                        this.m_datePicker.setDateString(d);
                        this.m_mode.setSelectedItem((Object)ComboItem.DATE);
                        found = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    this.m_mode.setSelectedItem((Object)ComboItem.EXPRESSION);
                }
            }
        }
        this.enableControls();
    }

    public final Document getDocument() {
        return this.m_text.getDocument();
    }

    private void updateText() {
        ComboItem i = (ComboItem)((Object)this.m_mode.getSelectedItem());
        if (i == ComboItem.UNSPECIFED) {
            this.m_text.setText(null);
        } else if (i == ComboItem.SYSDATE) {
            this.m_text.setText(SYSDATE);
        } else if (i == ComboItem.DAILY) {
            this.m_text.setText(SYSDATE_PLUS_1);
        } else if (i == ComboItem.HOURLY) {
            this.m_text.setText(SYSDATE_PLUS_124);
        } else if (i == ComboItem.DATE) {
            this.m_text.setText(this.getToDateString(this.m_datePicker.getDateString()));
        }
    }

    private void enableControls() {
        ComboItem i = (ComboItem)((Object)this.m_mode.getSelectedItem());
        this.m_datePicker.setVisible(i == ComboItem.DATE);
        this.m_datePicker.setEnabled(i == ComboItem.DATE);
        this.m_text.setVisible(i != ComboItem.DATE);
        this.m_text.setEnabled(i != ComboItem.DATE);
        this.m_text.setEditable(i == ComboItem.EXPRESSION);
    }

    public String getValue() {
        return this.m_text.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_mode.setEnabled(enabled);
        if (enabled) {
            this.enableControls();
        } else {
            this.m_datePicker.setEnabled(false);
            this.m_text.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_mode.isEnabled();
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.m_mode.setName(name + "_mode");
        this.m_datePicker.setName(name + "_datePicker");
        this.m_text.setName(name + "_text");
    }

    private String getToDateString(String date) {
        StringBuilder sb = new StringBuilder("TO_DATE('");
        sb.append(date);
        sb.append("','DD-MON-YYYY HH24:MI:SS')");
        return sb.toString();
    }

    private static enum ComboItem {
        UNSPECIFED("MV_REFRESH_DATE_EXPR_UNSPECIFIED"),
        SYSDATE("MV_REFRESH_DATE_EXPR_NOW"),
        DAILY("MV_REFRESH_DATE_EXPR_DAILY"),
        HOURLY("MV_REFRESH_DATE_EXPR_HOURLY"),
        DATE("MV_REFRESH_DATE_EXPR_DATE"),
        EXPRESSION("MV_REFRESH_DATE_EXPR_EXPRESSION");

        final String m_text;

        private ComboItem(String id) {
            this.m_text = UIBundle.get(id);
        }

        public String toString() {
            return this.m_text;
        }
    }
}

