/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public class ExtendedTable {
    private static final String CLIENT_KEY = "oracle.ideimpl.db.controls.ExtendedTable";
    private final DBUIResourceHelper m_resHelp;
    private final ReorderableTableWithTitleBar m_component;
    private final GenericTable m_table;
    private StringTableModel m_tableModel;
    private final JButton m_addButton;
    private final JButton m_deleteButton;
    private Collection<Document> m_cellEditorDocument;
    private boolean m_dirtyModel;
    private boolean m_enabled = true;
    private final Collection<Document> m_documents = new CopyOnWriteArrayList<Document>();
    private final DocumentListener m_docListener = new CellDocumentListener();
    private final Collection<TableModelListener> m_listeners = new CopyOnWriteArrayList<TableModelListener>();

    public ExtendedTable(String tableHeaderText, String name) {
        this.m_resHelp = new DBUIResourceHelper(name);
        this.m_table = this.createTable();
        this.m_table.setColumnSelectorAvailable(false);
        if (this.shouldTerminateEditOnFocusLost()) {
            this.m_table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        }
        this.m_table.putClientProperty((Object)CLIENT_KEY, (Object)this);
        this.m_resHelp.setName((Component)this.m_table, "Table");
        this.m_table.setDefaultEditor(String.class, (TableCellEditor)new StringCellEditor());
        JScrollPane sp = new JScrollPane((Component)this.m_table);
        sp.putClientProperty(CLIENT_KEY, this);
        this.m_component = new ReorderableTableWithTitleBar((JTable)this.m_table, this.isReorderable(), false);
        if (ModelUtil.hasLength((String)tableHeaderText) && !tableHeaderText.endsWith(":")) {
            tableHeaderText = tableHeaderText + ":";
        }
        TableToolbar toolbar = new TableToolbar((JTable)this.m_table, tableHeaderText);
        this.m_addButton = this.createAddButton();
        this.m_deleteButton = this.createDeleteButton();
        ListSelectionModel listSelectionModel = this.m_table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.setSelectionModel(listSelectionModel);
        this.m_component.setTableToolbar(toolbar);
        this.setButtonsVisible(true);
        this.m_component.putClientProperty((Object)CLIENT_KEY, (Object)this);
        this.m_resHelp.setName((Component)this.m_component, "TableWithToolbar");
        this.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExtendedTable.this.m_dirtyModel = true;
                ExtendedTable.this.checkButtons();
            }
        });
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_resHelp;
    }

    protected boolean isReorderable() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        if (this.m_component != null) {
            this.setEnabled((Component)this.m_component.getReorderableBar(), enabled);
            this.checkButtons();
        }
    }

    private void checkButtons() {
        this.setEnabled(this.m_addButton, this.m_enabled && this.m_table.getColumnCount() > 0);
        this.setEnabled(this.m_deleteButton, this.m_enabled && this.canRemoveRow(this.m_table.getSelectedRowInModel()));
    }

    private void setEnabled(Component c, boolean enabled) {
        if (c != null) {
            c.setEnabled(enabled);
        }
    }

    protected boolean canRemoveRow(int row) {
        return row >= 0;
    }

    public final void addTableModelListener(TableModelListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
            if (this.m_tableModel != null) {
                this.m_tableModel.addTableModelListener(listener);
            }
        }
    }

    public final void removeTableModelListener(TableModelListener listener) {
        this.m_listeners.remove(listener);
        if (this.m_tableModel != null) {
            this.m_tableModel.removeTableModelListener(listener);
        }
    }

    private GenericTable createTable() {
        return new GenericTable(){

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component retval = super.prepareEditor(editor, row, column);
                ExtendedTable.this.prepareEditorComponent(retval, editor, row, column);
                return retval;
            }

            public void editingCanceled(ChangeEvent e) {
                ExtendedTable.this.clearCellEditorDocuments();
                super.editingCanceled(e);
            }

            public void editingStopped(ChangeEvent e) {
                ExtendedTable.this.clearCellEditorDocuments();
                super.editingStopped(e);
            }
        };
    }

    protected void prepareEditorComponent(Component component, TableCellEditor editor, int row, int column) {
        this.clearCellEditorDocuments();
        this.registerDocumentListener(component);
        if (editor instanceof ExtendedTableCellEditor) {
            ((ExtendedTableCellEditor)editor).prepareComponent(component);
        }
    }

    private void registerDocumentListener(Component component) {
        if (component instanceof JTextComponent) {
            this.registerCellEditorDocument(((JTextComponent)component).getDocument());
        } else if (component instanceof JComboBox) {
            ComboBoxEditor ed = ((JComboBox)component).getEditor();
            if (ed != null) {
                this.registerDocumentListener(ed.getEditorComponent());
            }
        } else if (component instanceof JPanel) {
            for (Component kid : ((JPanel)component).getComponents()) {
                this.registerDocumentListener(kid);
            }
        }
    }

    private void clearCellEditorDocuments() {
        for (Document doc : this.m_documents) {
            doc.removeDocumentListener(this.m_docListener);
        }
        this.m_documents.clear();
    }

    private void registerCellEditorDocument(Document document) {
        if (!this.m_documents.contains(document)) {
            this.m_documents.add(document);
            document.addDocumentListener(this.m_docListener);
        }
    }

    protected final void fireCellEditedEvent() {
        if (this.m_tableModel != null && !this.m_listeners.isEmpty()) {
            GenericTable table = this.getTable();
            int col = table.getEditingColumn();
            int row = table.getEditingRow();
            TableModelEvent evt = new TableModelEvent((TableModel)((Object)this.m_tableModel), row, row, col, 0);
            for (TableModelListener listener : this.m_listeners) {
                if (!(listener instanceof ExtendedTableModelListener)) continue;
                ((ExtendedTableModelListener)listener).cellValueEdited(evt);
            }
        }
    }

    protected boolean shouldTerminateEditOnFocusLost() {
        return false;
    }

    private JButton createAddButton() {
        JButton retval = new JButton();
        this.m_resHelp.resIconicButton(retval, OracleIcons.getIcon((String)"add.png"), this.getAddActionText(), "Add");
        retval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedTable.this.stopCellEditing();
                ExtendedTable.this.addNewRow();
                int newRow = ExtendedTable.this.m_tableModel.getRowCount() - 1;
                ExtendedTable.this.m_table.setSelectedRowInModel(newRow);
                ExtendedTable.this.m_table.scrollToSelection();
                if (ExtendedTable.this.m_table.editCellAt(newRow, 0)) {
                    ExtendedTable.this.m_table.getEditorComponent().requestFocusInWindow();
                }
            }
        });
        return retval;
    }

    protected void addNewRow() {
        this.m_tableModel.addRow(new Vector(this.m_tableModel.getColumnCount()));
    }

    public void setButtonsVisible(boolean visible) {
        TableToolbar toolbar = this.m_component.getTableToolbar();
        if (toolbar != null) {
            toolbar.removeActionControl((Component)this.m_addButton);
            toolbar.removeActionControl((Component)this.m_deleteButton);
            if (visible) {
                toolbar.addActionControl((Component)this.m_addButton, true);
                toolbar.addActionControl((Component)this.m_deleteButton, true);
            }
        }
    }

    private JButton createDeleteButton() {
        JButton retval = new JButton();
        this.m_resHelp.resIconicButton(retval, OracleIcons.getIcon((String)"delete.png"), this.getDeleteActionText(), "Delete");
        retval.setEnabled(false);
        retval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedTable.this.stopCellEditing();
                int row = ExtendedTable.this.m_table.getSelectedRowInModel();
                if (row >= 0) {
                    ExtendedTable.this.m_tableModel.removeRow(row);
                    int left = ExtendedTable.this.m_table.getRowCount();
                    if (left > 0) {
                        ExtendedTable.this.m_table.setSelectedRowInModel(row < left ? row : left - 1);
                    }
                }
            }
        });
        return retval;
    }

    protected String getDeleteActionText() {
        return UIBundle.get("LIST_BUTTONS_REMOVE");
    }

    protected String getAddActionText() {
        return UIBundle.get("LIST_BUTTONS_ADD");
    }

    public final ReorderableTableWithTitleBar getComponent() {
        return this.m_component;
    }

    public final GenericTable getTable() {
        return this.m_table;
    }

    public final void setSelectionModel(ListSelectionModel selModel) {
        this.getTable().setSelectionModel(selModel);
        selModel.addListSelectionListener(e -> this.checkButtons());
    }

    public void setModel(StringTableModel model) {
        if (this.m_tableModel != null) {
            for (TableModelListener listener : this.m_listeners) {
                this.m_tableModel.removeTableModelListener(listener);
            }
        }
        this.m_tableModel = model;
        this.m_table.setModel((TableModel)((Object)this.m_tableModel));
        this.modelReplaced();
        this.m_dirtyModel = false;
        this.checkButtons();
        for (TableModelListener listener : this.m_listeners) {
            model.addTableModelListener(listener);
        }
    }

    public final boolean isModelDirty() {
        return this.m_dirtyModel;
    }

    protected void modelReplaced() {
    }

    public final StringTableModel getModel() {
        return this.m_tableModel;
    }

    public void stopCellEditing() {
        TableCellEditor ed = this.m_table.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        this.clearCellEditorDocuments();
    }

    public static ExtendedTable getExtendedTable(JComponent component) {
        return (ExtendedTable)component.getClientProperty(CLIENT_KEY);
    }

    public Vector<String> getPropertyColumnNames(String ... props) {
        Vector<String> victor = new Vector<String>();
        for (String prop : props) {
            victor.add(PropertyDisplayRegistry.getDisplayName(prop));
        }
        return victor;
    }

    public class StringTableModel
    extends GenericBaseTableModel {
        public StringTableModel(Vector<Vector> model, Vector<String> colNames) {
            super(model, colNames);
        }

        public boolean canHide(int column) {
            return false;
        }

        public boolean isCellEditable(int row, int column) {
            return ExtendedTable.this.m_enabled;
        }

        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        public void setValueAt(Object aValue, int row, int column) {
            Object was = this.getValueAt(row, column);
            if (ModelUtil.areDifferent((Object)aValue, (Object)was) && (was != null || !"".equals(aValue))) {
                super.setValueAt(aValue, row, column);
            }
        }
    }

    public static interface ExtendedTableCellEditor
    extends TableCellEditor {
        public void prepareComponent(Component var1);
    }

    public static interface ExtendedTableModelListener
    extends TableModelListener {
        public void cellValueEdited(TableModelEvent var1);
    }

    protected class EditableComboCellEditor
    extends DefaultCellEditor {
        public EditableComboCellEditor(String name, String ... entries) {
            this(new JComboBox(), name);
            for (String entry : entries) {
                ((JComboBox)this.getComponent()).addItem(entry);
            }
        }

        public EditableComboCellEditor(JComboBox combo, String name) {
            super(combo);
            combo.setEditable(true);
            ExtendedTable.this.getResourceHelper().setName(combo, name);
            combo.getEditor().getEditorComponent().setName(combo.getName() + "-editor");
        }

        protected final JComboBox getCombo() {
            return (JComboBox)this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getCombo().getEditor().getItem();
        }

        protected final JTextComponent getEditorComponent() {
            return (JTextComponent)this.getCombo().getEditor().getEditorComponent();
        }
    }

    private class StringCellEditor
    extends DefaultCellEditor {
        StringCellEditor() {
            super(new JTextField());
            ExtendedTable.this.getResourceHelper().setName(this.getComponent(), "StringCellEditor");
            this.setClickCountToStart(1);
        }
    }

    private class CellDocumentListener
    implements DocumentListener {
        private CellDocumentListener() {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ExtendedTable.this.fireCellEditedEvent();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ExtendedTable.this.fireCellEditedEvent();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

