/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.Vector;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.bigdata.BigDataTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataTableProperty;

public class BigDataTablePropertiesTable
extends KeyValueTable {
    public BigDataTablePropertiesTable() {
        super(PropertyDisplayRegistry.getDisplayName("bigDataTableProperties"), "BigDataTablePropertiesTable");
    }

    public void setTableProperties(BigDataTableProperties props) {
        Vector<Vector> data = new Vector<Vector>();
        if (props != null) {
            for (BigDataTableProperty prop : props.getBigDataTableProperties()) {
                Vector<String> row = new Vector<String>();
                row.add(prop.getName());
                row.add(prop.getTablePropertyValue());
                data.add(row);
            }
        }
        this.setModel(new ExtendedTable.StringTableModel(this, data, this.getPropertyColumnNames("name", "tablePropertyValue")));
    }

    public BigDataTableProperties getTableProperties() {
        Vector data = this.getModel().getDataVector();
        BigDataTableProperties retval = null;
        if (!data.isEmpty()) {
            retval = new BigDataTableProperties();
            for (Vector row : data) {
                retval.addBigDataTableProperty(new BigDataTableProperty((String)row.get(0), (String)row.get(1)));
            }
        }
        return retval;
    }

    @Override
    protected void addNewRow() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object row : this.getModel().getDataVector()) {
            names.add((String)((Vector)row).get(0));
        }
        String name = DBUtil.getUniqueName(names, (String)"property1");
        this.getModel().addRow(new Object[]{name, null});
    }

    @Override
    protected boolean isReorderable() {
        return true;
    }
}

