/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.controls.BigDataValueCellEditor;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.ModelUtil;

public class BigDataAccessParamsTable
extends KeyValueTable {
    public BigDataAccessParamsTable() {
        super(PropertyDisplayRegistry.getDisplayName("accessParameters"), "BigDataAccessParametersTable");
    }

    public void setAccessParameters(BigDataAccessParameters params, Relation relation, DBObjectProvider provider) {
        this.stopCellEditing();
        Vector<Vector> rows = new Vector<Vector>();
        if (params != null) {
            for (BigDataAccessParameter param : params.getBigDataAccessParameters()) {
                Vector<String> row = new Vector<String>();
                row.add(param.getName());
                row.add(param.getParameterValue());
                rows.add(row);
            }
        }
        this.setModel(new ExtendedTable.StringTableModel(this, rows, this.getPropertyColumnNames("name", "parameterValue")));
        TableColumn keyCol = this.getTable().getColumnModel().getColumn(0);
        TableColumn valCol = this.getTable().getColumnModel().getColumn(1);
        keyCol.setPreferredWidth(50);
        valCol.setPreferredWidth(200);
        valCol.setCellEditor(new BigDataValueCellEditor(this, provider, relation));
        valCol.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof String) {
                    value = BigDataAccessParameterMetadata.stripLineEscapes((String)((String)value)).replace("\n", " ");
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    public BigDataAccessParameters getAccessParameters() {
        this.stopCellEditing();
        ExtendedTable.StringTableModel model = this.getModel();
        ArrayList<BigDataAccessParameter> params = new ArrayList<BigDataAccessParameter>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Object val;
            BigDataAccessParameter param = new BigDataAccessParameter();
            Object name = model.getValueAt(i, 0);
            if (name != null) {
                param.setName(name.toString());
            }
            if ((val = model.getValueAt(i, 1)) != null) {
                param.setParameterValue(val.toString());
            }
            if (name == null && val == null) continue;
            params.add(param);
        }
        BigDataAccessParameters frag = new BigDataAccessParameters();
        frag.setBigDataAccessParameters(params.toArray(new BigDataAccessParameter[params.size()]));
        return frag;
    }

    @Override
    protected void keyChanged(String newKey, int row) {
        String oldKey;
        GenericTable table = this.getTable();
        boolean rowExists = table.getModel().getRowCount() > row;
        String string = oldKey = rowExists ? (String)table.getValueAt(row, 0) : null;
        if (ModelUtil.areDifferent((Object)oldKey, (Object)newKey)) {
            BigDataAccessParameterMetadata.TemplateValue newTemplate = BigDataAccessParameterMetadata.getParameterTemplateValue((String)newKey);
            String oldValue = rowExists ? (String)table.getValueAt(row, 1) : null;
            BigDataAccessParameterMetadata.TemplateValue oldTemplate = BigDataAccessParameterMetadata.getParameterTemplateValue((String)oldKey);
            if (newTemplate != null) {
                if (oldValue == null || "".equals(oldValue) || oldTemplate != null) {
                    table.setValueAt((Object)newTemplate.toString(), row, 1);
                }
            } else if (oldTemplate != null && oldValue != null) {
                String before = oldTemplate.getBefore();
                String after = oldTemplate.getAfter();
                StringBuilder like = new StringBuilder();
                if (before != null) {
                    like.append(Pattern.quote(before));
                }
                like.append(".*");
                if (after != null) {
                    like.append(Pattern.quote(after));
                }
                if (oldValue.matches(like.toString())) {
                    table.setValueAt(null, row, 1);
                }
            }
        }
    }
}

