/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractLazyCombo
extends JComboBox
implements ListCellRenderer {
    private final Object NULL_OBJ = new Object();
    private final DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private boolean m_gotModel = false;
    private boolean m_inMenuWillBecomeVisible = false;
    private boolean m_menuVisible = false;
    private boolean m_settingModel = false;
    private Thread m_loadingThread = null;

    public AbstractLazyCombo() {
        this.setRenderer(this);
        this.setEditor(new CustomComboBoxEditor());
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AbstractLazyCombo.this.doBeforeLoading();
                if (!AbstractLazyCombo.this.m_gotModel && !AbstractLazyCombo.this.m_inMenuWillBecomeVisible) {
                    AbstractLazyCombo.this.loadModel();
                }
                AbstractLazyCombo.this.m_menuVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }
        });
    }

    protected abstract List getModelEntries();

    public String getNullText() {
        return null;
    }

    protected Icon getIcon(Object value) {
        return null;
    }

    public void reset() {
        this.cancel();
        this.m_gotModel = false;
    }

    public final void cancel() {
        Thread oldThread = this.m_loadingThread;
        if (oldThread != null && oldThread.isAlive()) {
            oldThread.interrupt();
            StatementWrapper.cancelExecution((Thread)oldThread);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (!this.m_menuVisible) {
            super.processFocusEvent(e);
        }
    }

    protected final void loadModel() {
        if (!this.m_gotModel) {
            Object curr = this.getCurrentValue();
            DefaultComboBoxModel<Object> initialModel = new DefaultComboBoxModel<Object>();
            if (!this.isEditable()) {
                initialModel.addElement(curr);
            }
            initialModel.addElement(UIBundle.get("DBOBJECT_TREE_LOADING_NODE"));
            initialModel.setSelectedItem(curr);
            this.setModel(initialModel, false);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String nullText = AbstractLazyCombo.this.getNullText();
                    final ArrayList<Object> toAdd = new ArrayList<Object>();
                    if (nullText != null) {
                        toAdd.add(AbstractLazyCombo.this.NULL_OBJ);
                    }
                    toAdd.addAll(AbstractLazyCombo.this.getModelEntries());
                    final Thread currThread = Thread.currentThread();
                    if (AbstractLazyCombo.this.isVisible() && !currThread.isInterrupted()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractLazyCombo.this.isVisible() && !currThread.isInterrupted()) {
                                    Logger logger;
                                    Object current = AbstractLazyCombo.this.getCurrentValue();
                                    boolean isPopupVisible = AbstractLazyCombo.this.isPopupVisible();
                                    DefaultComboBoxModel model = new DefaultComboBoxModel();
                                    for (Object o : toAdd) {
                                        model.addElement(o);
                                    }
                                    model.setSelectedItem(current == null ? AbstractLazyCombo.this.NULL_OBJ : current);
                                    AbstractLazyCombo.this.setModel(model, true);
                                    if (isPopupVisible) {
                                        AbstractLazyCombo.this.showPopup();
                                    }
                                    if ((logger = Logger.getLogger("oracle.abbot.test")) != null) {
                                        logger.log(Level.FINE, AbstractLazyCombo.this.getLoadMessage());
                                    }
                                }
                            }
                        });
                    }
                }
            };
            Thread oldThread = this.m_loadingThread;
            if (oldThread == null || oldThread.isInterrupted() || !oldThread.isAlive()) {
                this.m_loadingThread = new Thread(r, "loadModelEntries");
                this.m_loadingThread.start();
            }
        }
    }

    protected String getLoadMessage() {
        return this.getName() + ".loaded";
    }

    protected void doBeforeClearingModel() {
    }

    protected void doBeforeLoading() {
    }

    protected void doAfterClearingModel() {
    }

    public void setModel(ComboBoxModel model) {
        this.setModel(model, false);
    }

    public void setModel(ComboBoxModel model, boolean gotModel) {
        try {
            this.m_settingModel = true;
            this.doBeforeClearingModel();
            super.setModel(model);
        }
        finally {
            this.doAfterClearingModel();
            this.m_settingModel = false;
            this.m_gotModel = gotModel;
        }
    }

    @Override
    public void revalidate() {
        if (!this.m_settingModel) {
            super.revalidate();
        }
    }

    @Override
    public Object getSelectedItem() {
        Object ret = super.getSelectedItem();
        if (ret == this.NULL_OBJ) {
            return null;
        }
        if (UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(ret)) {
            Component editor = this.getEditor().getEditorComponent();
            if (editor instanceof JTextField && this.isEditable()) {
                String text = ((JTextField)editor).getText();
                return !ModelUtil.hasLength((String)text) || this.isInternalValue(text) ? null : text;
            }
            Object alreadySelected = this.getModel().getElementAt(0);
            if (alreadySelected == null) {
                return null;
            }
            return alreadySelected.equals(UIBundle.get("DBOBJECT_TREE_LOADING_NODE")) ? null : alreadySelected;
        }
        return ret;
    }

    @Override
    public void setSelectedItem(Object val) {
        if (val == null) {
            val = this.NULL_OBJ;
        }
        super.setSelectedItem(val);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp;
        Object iconValue = value;
        if (value == null || value == this.NULL_OBJ) {
            value = this.getNullText();
            iconValue = null;
        }
        if ((comp = this.m_delegateLCR.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus)) instanceof JLabel) {
            ((JLabel)comp).setIcon(this.getIcon(iconValue));
            if (value != null && UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(value)) {
                comp.setEnabled(false);
            }
        }
        return comp;
    }

    public boolean isModelLoaded() {
        return this.m_gotModel;
    }

    protected boolean isInternalValue(Object obj) {
        return this.NULL_OBJ == obj || UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(obj);
    }

    private Object getCurrentValue() {
        String text;
        Component editor = this.getEditor().getEditorComponent();
        Object current = editor instanceof JTextField && this.isEditable() ? (!ModelUtil.hasLength((String)(text = ((JTextField)editor).getText())) || this.isInternalValue(text) ? this.NULL_OBJ : text) : this.getSelectedItem();
        return current;
    }

    protected JTextField createEditorTextField() {
        return new CustomJTextField();
    }

    protected class CustomJTextField
    extends JTextField {
        public CustomJTextField() {
            super("", 9);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (!AbstractLazyCombo.this.m_menuVisible) {
                super.processFocusEvent(e);
            }
        }

        @Override
        public void setText(String s) {
            if (ModelUtil.areDifferent((Object)this.getText(), (Object)s)) {
                super.setText(s);
            }
        }

        @Override
        public String getName() {
            String base;
            String retval = super.getName();
            if (retval == null && (base = this.getBaseName()) != null) {
                retval = base + "-editor";
            }
            return retval;
        }

        protected String getBaseName() {
            return AbstractLazyCombo.this.getName();
        }
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            return AbstractLazyCombo.this.createEditorTextField();
        }
    }
}

