/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.components.DelegateComponentWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.table.BigDataAccessParametersComponentWrapper;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class AccessParametersComponentWrapper
extends DelegateComponentWrapper {
    private static final String DEFAULT = "DEFAULT";
    private static final String BIGDATA = "BIGDATA";
    private final BigDataAccessParametersComponentWrapper m_bigDataWrapper = new BigDataAccessParametersComponentWrapper();
    private ComponentWrapper m_clobWrapper;
    private final JCheckBox m_chkAdvanced = new JCheckBox(StringUtils.stripMnemonic((String)UIBundle.get("TABLE_INFO_ADVANCED")));

    public AccessParametersComponentWrapper() {
        this.m_chkAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccessParametersComponentWrapper.this.isActive()) {
                    AccessParametersComponentWrapper.this.m_bigDataWrapper.writeUpdates();
                    AccessParametersComponentWrapper.this.getDelegate();
                }
            }
        });
        this.m_chkAdvanced.setOpaque(false);
    }

    public void setCLOBWrapper(ComponentWrapper wrapper) {
        this.m_clobWrapper = wrapper;
        wrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AccessParametersComponentWrapper.this.getDelegate();
            }
        });
    }

    @Override
    protected void registerDelegateWrappers() {
        this.registerDelegateWrapper(DEFAULT, TextPropertyComponentWrapper.createTextWrapper(this.getComponentContext()));
        this.registerDelegateWrapper(BIGDATA, this.m_bigDataWrapper);
    }

    private void checkAdvancedEnabled() {
        this.m_chkAdvanced.setEnabled(!Boolean.TRUE.equals(this.m_clobWrapper.getPropertyValue()));
    }

    @Override
    protected String getDelegateKey() {
        String retval = DEFAULT;
        String driver = this.getCurrentDriver();
        if (BigDataAccessParameterMetadata.isBigDataAccessDriver((String)driver) && !this.m_chkAdvanced.isSelected() && this.m_clobWrapper != null && !((JCheckBox)this.m_clobWrapper.getActiveComponent()).isSelected()) {
            boolean hasParams;
            OracleExternalTableProperties props = this.getCurrentProperties();
            String accessParams = props.getAccessParameters();
            boolean bl = hasParams = accessParams != null && accessParams.trim().length() > 0;
            if (!hasParams || props.getAccessParametersFragment() != null) {
                retval = BIGDATA;
            } else if (hasParams) {
                this.m_chkAdvanced.setSelected(true);
            }
        }
        this.checkAdvancedEnabled();
        return retval;
    }

    private OracleExternalTableProperties getCurrentProperties() {
        return (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties");
    }

    private String getCurrentDriver() {
        String retval = null;
        OracleExternalTableProperties props = this.getCurrentProperties();
        if (props != null) {
            retval = props.getAccessDriverType();
        }
        return retval;
    }

    @Override
    protected Component createComponentForLayout() {
        JPanel cardPanel = (JPanel)this.getActiveComponent();
        ReorderableTableWithTitleBar wrapper = this.m_bigDataWrapper.getKeyValueTable().getComponent();
        TableToolbar toolbar = wrapper.getTableToolbar();
        Component clobComp = this.m_clobWrapper.getComponent();
        DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)clobComp);
        toolbar.addActionControl(clobComp, false);
        toolbar.addActionControl(Box.createHorizontalStrut(24), false);
        this.m_chkAdvanced.setName(((JPanel)this.getActiveComponent()).getName() + ".Advanced");
        wrapper.setTableContainer((JComponent)cardPanel);
        wrapper.setPreferredSize(new Dimension(290, 150));
        return wrapper;
    }

    @Override
    protected void fireDelegateChanged(String oldKey, String newKey) {
        boolean bdLayout = BIGDATA.equals(newKey);
        KeyValueTable kvt = this.m_bigDataWrapper.getKeyValueTable();
        kvt.setButtonsVisible(bdLayout);
        TableToolbar toolbar = kvt.getComponent().getTableToolbar();
        toolbar.removeActionControl((Component)this.m_chkAdvanced);
        if (bdLayout || BigDataAccessParameterMetadata.isBigDataAccessDriver((String)this.getCurrentDriver())) {
            toolbar.addActionControl((Component)this.m_chkAdvanced, false);
        }
    }
}

