/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ideimpl.db.components.AsynchronousDocumentComponentWrapper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.util.ModelUtil;

public abstract class TextPropertyComponentWrapper<T extends JTextComponent>
extends AsynchronousDocumentComponentWrapper<T> {
    private boolean m_internalise;

    protected TextPropertyComponentWrapper(T component) {
        super(component);
    }

    @Override
    public Object getPropertyValue() {
        String value = ((JTextComponent)this.getActiveComponent()).getText();
        if (value != null) {
            if (this.m_internalise) {
                value = this.getProvider().getInternalName(value);
            }
            if (value.length() == 0) {
                value = null;
            }
        }
        return value;
    }

    @Override
    protected void writeFinished(boolean successful) {
        if (this.refreshAfterWrite() && successful) {
            this.refreshObject(this.getUpdatedObject());
        }
    }

    protected boolean refreshAfterWrite() {
        return this.m_internalise;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((JTextComponent)this.getActiveComponent()).setEditable(enabled);
    }

    @Override
    protected void setPropertyValueImpl(Object value) {
        JTextComponent text = (JTextComponent)this.getActiveComponent();
        String existingText = text.getText();
        String newText = value instanceof String ? (this.m_internalise ? this.getProvider().getExternalName((String)value) : (String)value) : null;
        if (ModelUtil.areDifferent(newText, (Object)existingText)) {
            text.setText(newText);
        }
    }

    @Override
    protected Document getDocument() {
        return ((JTextComponent)this.getActiveComponent()).getDocument();
    }

    private void setInternalise(boolean internalise) {
        this.m_internalise = internalise;
    }

    @Override
    protected void initialiseComponent() {
        String type = this.getUpdatedObject().getType();
        String propName = this.getPropertyName();
        PropertyCriteria crit = new PropertyCriteria();
        crit.setDerived(Boolean.valueOf(true));
        crit.addPredicate(pi -> propName.equals(pi.getDerivedSourceProperty()) && SQLFragment.class.isAssignableFrom(pi.getPropertyClass()));
        DBObject obj = this.getUpdatedObject();
        if (Metadata.getInstance().hasSupportedProperty(this.getUpdatedObject().getClass(), null, (Predicate)crit)) {
            DBInsightContext ctx = new DBInsightContext();
            ctx.setProvider(this.getProvider());
            ctx.setContextObject(obj);
            Context ideContext = (Context)this.getComponentContext().getDataContext().find(Context.class);
            DBCompletionSupportFactory.getCompletionSupport(ctx, ideContext, (JTextComponent)this.getActiveComponent());
        }
        super.initialiseComponent();
    }

    public static TextPropertyComponentWrapper createTextWrapper(ComponentContext context) {
        PropertyInfo propInfo = context.getPropertyInfo();
        TextPropertyComponentWrapper retval = context.isInTable() && propInfo.isTextMultiLine() ? TextPropertyComponentWrapper.createExtendedTextFieldWrapper() : (propInfo.isTextPassword() ? new PasswordTextWrapper() : (propInfo.isTextMultiLine() ? TextPropertyComponentWrapper.createMultiLineTextWrapper() : ("name".equals(context.getPropertyName()) ? new NameWrapper() : new SingleLineTextWrapper())));
        super.setInternalise(propInfo.isTextInternalName());
        return retval;
    }

    static TextPropertyComponentWrapper<ExtendedTextField> createExtendedTextFieldWrapper() {
        return new ExtendedTextFieldWrapper();
    }

    private static TextPropertyComponentWrapper<JTextArea> createMultiLineTextWrapper() {
        return new MultiLineTextWrapper();
    }

    static TextPropertyComponentWrapper<JTextArea> createMultiLineSQLTextWrapper(PropertyInfo propInfo) {
        SQLFragmentExpressionBuilder.ExpressionType expressionType = SQLFragmentExpressionBuilder.ExpressionType.ITEM;
        if ("checkCondition".equals(propInfo.getPropertyName())) {
            expressionType = SQLFragmentExpressionBuilder.ExpressionType.CONDITION;
        }
        return new MultiLineSQLTextWrapper(expressionType);
    }

    private static class MultiLineTextWrapper
    extends TextPropertyComponentWrapper<JTextArea> {
        public MultiLineTextWrapper() {
            super(new JTextArea());
        }

        @Override
        public Component getCellEditorComponent() {
            JTextArea text = (JTextArea)this.getActiveComponent();
            text.setRows(4);
            text.setColumns(20);
            PopupButton popup = new PopupButton((JComponent)new JScrollPane(text));
            return popup;
        }

        @Override
        protected void setPropertyValueImpl(Object value) {
            super.setPropertyValueImpl(value);
            ((JTextArea)this.getActiveComponent()).setCaretPosition(0);
        }

        @Override
        protected Component createComponentForLayout() {
            JTextArea text = (JTextArea)this.getActiveComponent();
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            JScrollPane retval = new JScrollPane(text);
            if (this.getComponentContext().isInFlatEditor()) {
                retval = new ResizeComponent((JComponent)retval);
            }
            retval.setPreferredSize(new Dimension(300, 100));
            return retval;
        }
    }

    private static class PasswordTextWrapper
    extends SingleLineTextWrapper<JPasswordField> {
        public PasswordTextWrapper() {
            super(new JPasswordField());
        }
    }

    private static class ExtendedTextFieldWrapper
    extends SingleLineTextWrapper<ExtendedTextField> {
        public ExtendedTextFieldWrapper() {
            super(new ExtendedTextField());
        }

        @Override
        protected void initialiseComponent() {
            super.initialiseComponent();
            ((ExtendedTextField)this.getActiveComponent()).setAllowBreaks(true);
        }
    }

    private static class NameWrapper<T extends JTextField>
    extends SingleLineTextWrapper<T> {
        public NameWrapper() {
            this(new JTextField());
        }

        protected NameWrapper(T textField) {
            super(textField);
            this.addVetoChangeListener();
        }

        protected void addVetoChangeListener() {
            this.addVetoListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    String value = ((JTextField)this.getActiveComponent()).getText();
                    try {
                        String type = this.getUpdatedObject().getType();
                        this.getProvider().validateName(type, value);
                    }
                    catch (InvalidNameException e) {
                        throw new PropertyVetoException(e.getMessage(), evt);
                    }
                }
            });
        }

        @Override
        protected void initialiseComponent() {
            super.initialiseComponent();
            ((JTextField)this.getActiveComponent()).setColumns(1);
        }

        @Override
        protected boolean refreshAfterWrite() {
            return true;
        }
    }

    public static class SingleLineTextWrapper<T extends JTextField>
    extends TextPropertyComponentWrapper<T> {
        public SingleLineTextWrapper() {
            this(new JTextField());
        }

        protected SingleLineTextWrapper(T textField) {
            super(textField);
        }

        @Override
        protected void initialiseComponentListener() {
            super.initialiseComponentListener();
            if (this.getComponentContext().isInFlatEditor() && !this.getComponentContext().isInTable()) {
                ((JTextField)this.getActiveComponent()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.fireChangeEvent();
                    }
                });
            }
        }
    }

    private static class MultiLineSQLTextWrapper
    extends MultiLineTextWrapper {
        private final SQLFragmentExpressionBuilder.ExpressionType m_expressionType;

        public MultiLineSQLTextWrapper(SQLFragmentExpressionBuilder.ExpressionType expressionType) {
            this.m_expressionType = expressionType;
        }

        @Override
        protected void setPropertyValueImpl(Object value) {
            ((JTextArea)this.getActiveComponent()).setText(value instanceof SQLFragment ? ((SQLFragment)value).getSQLText() : null);
        }

        @Override
        public Object getPropertyValue() {
            String sqlText = ((JTextArea)this.getActiveComponent()).getText().trim();
            Relation relation = (Relation)DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Relation.class);
            SQLFragment frag = SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)this.getProvider(), (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)this.m_expressionType, (String)sqlText);
            return frag;
        }

        @Override
        public Component getCellEditorComponent() {
            JTextArea text = (JTextArea)this.getActiveComponent();
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setRows(3);
            JScrollPane scroll = new JScrollPane(text, 20, 31);
            return scroll;
        }
    }
}

