/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ideimpl.db.components.IdArrayWrapper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectProviderListener;

public class SystemObjectIdArrayWrapper
extends IdArrayWrapper {
    private final DBObjectCriteria m_criteria;

    public SystemObjectIdArrayWrapper(Class<? extends DBObject> clz, DBObjectFilter filter, boolean addOrderButtons, DBObjectCriteria criteria) {
        super(clz, filter, addOrderButtons, null);
        this.m_criteria = criteria;
    }

    @Override
    protected List<DBObject> getAvailableList() {
        ArrayList<DBObject> ret = new ArrayList<DBObject>();
        try {
            ret.addAll(this.getProvider().listObjects(this.m_criteria));
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    protected DBObjectProviderListener createProviderListenerForRefresh() {
        return new DBObjectProviderListener(){

            private void refreshIfRequired(Collection<? extends SystemObject> objs) {
                for (SystemObject systemObject : objs) {
                    if (!SystemObjectIdArrayWrapper.this.m_criteria.accept(systemObject)) continue;
                    SystemObjectIdArrayWrapper.this.refreshUI();
                    break;
                }
            }

            public void schemaObjectsAdded(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
                this.refreshIfRequired(objs);
            }

            public void schemaObjectsRemoved(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
                this.refreshIfRequired(objs);
            }

            public void systemObjectsAdded(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
                this.refreshIfRequired(objs);
            }

            public void systemObjectsRemoved(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
                this.refreshIfRequired(objs);
            }
        };
    }
}

