/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class SubTypeComponentWrapper
extends EnumPropertyComponentWrapper {
    private Map<String, Object> m_cachedProperties;

    public SubTypeComponentWrapper() {
        this.addVetoListener(evt -> this.vetoPropertyChange(evt));
        this.addListener(evt -> this.processPropertyChange(evt));
    }

    private void vetoPropertyChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object newVal;
        Object oldVal;
        if (this.isActive() && ModelUtil.areDifferent((Object)(oldVal = evt.getOldValue()), (Object)(newVal = evt.getNewValue())) && this.vetoPropertyChange(oldVal, newVal)) {
            throw new PropertyVetoException(null, evt);
        }
    }

    protected boolean vetoPropertyChange(Object oldVal, Object newVal) {
        boolean veto = false;
        DBObject obj = this.getUpdatedObject();
        if (obj instanceof SystemObject) {
            SystemObject sysObj = (SystemObject)obj;
            try {
                SystemObject temp = (SystemObject)DBUtil.makeClonedCopy((DBObject)sysObj);
                this.getPropertyHelper().setPropertyValueOrFail((Object)temp, this.getPropertyName(), newVal);
                Map<String, Object> invalidProps = this.getInvalidProperties(temp);
                if (invalidProps != null && !invalidProps.isEmpty()) {
                    veto = !MessageDialog.confirm((Component)DBMessageDialog.getDialogParent(), (Object)this.getConfirmationMessage(newVal, invalidProps), (String)UIBundle.get("DBOBJECT_PROP_CONFIRM_TITLE"), null, (boolean)true);
                }
            }
            catch (MissingPropertyException mpe) {
                this.getLogger().warning(mpe.getMessage());
            }
        }
        return veto;
    }

    private void processPropertyChange(PropertyChangeEvent evt) {
        if (this.isActive()) {
            Object newType = evt.getNewValue();
            Object oldType = evt.getOldValue();
            if (ModelUtil.areDifferent((Object)oldType, (Object)newType)) {
                if (this.shouldEnsurePanels()) {
                    try {
                        PanelLibrary.ensurePanels(this.getComponentContext().getDataContext(), dataContext -> this.clearInvalidProperties());
                    }
                    catch (TraversalException te) {
                        te.showMessageDialog(this.getComponent());
                        this.resetPropertyValue(oldType);
                    }
                } else {
                    this.clearInvalidProperties();
                }
            }
        }
    }

    private void clearInvalidProperties() {
        SystemObject sysObj = (SystemObject)this.getUpdatedObject();
        SystemObject temp = (SystemObject)DBUtil.makeClonedCopy((DBObject)sysObj);
        Map<String, Object> invalidProps = this.getInvalidProperties(temp);
        for (Map.Entry<String, Object> entry : invalidProps.entrySet()) {
            String prop = entry.getKey();
            Object value = entry.getValue();
            this.clearInvalidProperty(sysObj, prop, value);
            if (this.getComponentContext().isInFlatEditor() || !this.shouldCacheInvalidProperty(prop)) continue;
            if (this.m_cachedProperties == null) {
                this.m_cachedProperties = new HashMap<String, Object>();
            }
            this.m_cachedProperties.put(prop, value);
        }
        if (this.m_cachedProperties != null && !this.m_cachedProperties.isEmpty()) {
            PropertyManager propMgr = this.getProvider().getPropertyManager();
            PropertyHelper helper = this.getPropertyHelper();
            HashMap<String, Object> leftOver = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.m_cachedProperties.entrySet()) {
                String prop = entry.getKey();
                Object value = entry.getValue();
                if (propMgr.canCreateProperty(temp, prop)) {
                    helper.setPropertyValue((Object)sysObj, prop, value);
                    continue;
                }
                leftOver.put(prop, value);
            }
            this.m_cachedProperties = leftOver;
        }
    }

    private String getConfirmationMessage(Object newVal, Map<String, Object> invalidProps) {
        StringBuilder props = new StringBuilder();
        for (String prop : invalidProps.keySet()) {
            if (props.length() > 0) {
                props.append("\n");
            }
            props.append(PropertyDisplayRegistry.getDisplayName(prop, this.getProvider(), this.getUpdatedObject()));
        }
        String retval = UIBundle.format("DBOBJECT_PROP_CONFIRM", this.getPropertyDisplayName(), PropertyDisplayRegistry.getPropValueDisplay(this.getPropertyName(), newVal), props);
        return retval;
    }

    protected boolean shouldCacheInvalidProperty(String prop) {
        return false;
    }

    protected boolean shouldRecurseToChildProperties(String prop) {
        return false;
    }

    protected boolean shouldTestProperty(String prop) {
        return !prop.equals("Timestamp") && !prop.equals("TemplateObject");
    }

    protected boolean shouldEnsurePanels() {
        return false;
    }

    protected Map<String, Object> getInvalidProperties(SystemObject obj) {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        this.findInvalidProperties(obj, (DBObject)obj, retval, null);
        return retval;
    }

    private void findInvalidProperties(SystemObject top, DBObject object, Map<String, Object> invalidProps, String base) {
        PropertyManager propMgr = this.getProvider().getPropertyManager();
        Map props = object.getProperties();
        for (Map.Entry entry : props.entrySet()) {
            String prop = (String)entry.getKey();
            Object value = entry.getValue();
            if (!this.shouldTestProperty(prop) || value == null) continue;
            String fullProp = base == null ? prop : Property.createPath((String[])new String[]{base, prop});
            boolean canCreate = propMgr.canCreateProperty(top, fullProp);
            if (!canCreate) {
                invalidProps.put(fullProp, value);
                continue;
            }
            if (!(value instanceof DBObject) || !this.shouldRecurseToChildProperties(fullProp)) continue;
            this.findInvalidProperties(top, (DBObject)value, invalidProps, fullProp);
        }
    }

    protected void clearInvalidProperty(SystemObject obj, String prop, Object value) {
        this.getPropertyHelper().setPropertyValue((Object)obj, prop, null);
    }

    protected boolean applyCachedProperty(SystemObject obj, String prop, Object value) {
        boolean retval = false;
        if (this.getProvider().getPropertyManager().canCreateProperty(obj, prop)) {
            this.getPropertyHelper().setPropertyValue((Object)obj, prop, value);
            retval = true;
        }
        return retval;
    }
}

