/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.panels.sql.SQLQueryComponentPanel;

public class SQLQueryComponentWrapper
extends AsynchronousComponentWrapper<JTextComponent> {
    private final SQLQueryComponentPanel m_panel;
    private final SQLQueryComponentPanel.SQLQueryListener m_queryListener = new SQLQueryComponentPanel.SQLQueryListener(){

        @Override
        public void queryUpdated() {
            SQLQueryComponentWrapper.this.markDirty();
        }
    };

    public SQLQueryComponentWrapper() {
        this(new SQLQueryComponentPanel());
    }

    private SQLQueryComponentWrapper(SQLQueryComponentPanel panel) {
        super(panel.getTextComponent());
        this.m_panel = panel;
    }

    @Override
    public JLabel getLabel() {
        return null;
    }

    @Override
    protected Component getDefaultValidationComponent() {
        return this.m_panel.getLabel();
    }

    @Override
    protected void initialiseComponent() {
        this.m_panel.initialisePanel(this.getComponentContext());
    }

    @Override
    public Object getPropertyValue() {
        return this.m_panel.getQueryString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(Object val) {
        boolean readd = this.m_panel.removeQueryListener(this.m_queryListener);
        try {
            String set = val == null ? null : val.toString().trim();
            this.m_panel.setQueryString(set);
        }
        finally {
            if (readd) {
                this.m_panel.addQueryListener(this.m_queryListener);
            }
        }
    }

    @Override
    protected void gainingFocus() {
        this.m_panel.removeQueryListener(this.m_queryListener);
        this.m_panel.addQueryListener(this.m_queryListener);
    }

    @Override
    protected void losingFocus() {
        this.m_panel.removeQueryListener(this.m_queryListener);
    }

    @Override
    public Component[] getFocusComponents() {
        return this.m_panel.getEditingComponents();
    }

    @Override
    protected Component createComponentForLayout() {
        return this.m_panel;
    }
}

