/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

public class IndexPartitionTypePropertyWrapper
extends EnumPropertyComponentWrapper {
    @Override
    protected ItemListener createItemListener() {
        return new TypeComboListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(Object value) {
        JComboBox comp;
        DefaultComboBoxModel model;
        IndexPartitionTypeComboItem select = IndexPartitionTypeComboItem.NONE;
        if (value instanceof OracleIndexPartitions.PartitionType) {
            OracleIndexPartitions.PartitionType type = (OracleIndexPartitions.PartitionType)value;
            select = this.getPartitionTypeComboItem(type);
        }
        if ((model = (DefaultComboBoxModel)(comp = (JComboBox)this.getActiveComponent()).getModel()).getIndexOf((Object)select) == -1) {
            model.insertElementAt(select, 0);
        }
        boolean active = this.isActive();
        this.setActive(false);
        try {
            ((JComboBox)this.getActiveComponent()).setSelectedItem((Object)select);
        }
        finally {
            this.setActive(active);
        }
    }

    private IndexPartitionTypeComboItem getPartitionTypeComboItem(OracleIndexPartitions.PartitionType type) {
        IndexPartitionTypeComboItem select = type == OracleIndexPartitions.PartitionType.GLOBAL_RANGE ? IndexPartitionTypeComboItem.GLOBAL_RANGE : (type == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? IndexPartitionTypeComboItem.GLOBAL_HASH : IndexPartitionTypeComboItem.LOCAL);
        return select;
    }

    @Override
    public Object getPropertyValue() {
        IndexPartitionTypeComboItem item = (IndexPartitionTypeComboItem)((Object)((JComboBox)this.getActiveComponent()).getSelectedItem());
        OracleIndexPartitions.PartitionType type = null;
        if (item == IndexPartitionTypeComboItem.GLOBAL_RANGE) {
            type = OracleIndexPartitions.PartitionType.GLOBAL_RANGE;
        } else if (item == IndexPartitionTypeComboItem.GLOBAL_HASH) {
            type = OracleIndexPartitions.PartitionType.GLOBAL_HASH;
        } else if (item == IndexPartitionTypeComboItem.LOCAL) {
            boolean isComposite;
            Index index = (Index)this.getUpdatedObject();
            Table table = (Table)index.getParent();
            OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            boolean bl = isComposite = otp.getSubpartitionModel() != null;
            if (otp == null) {
                type = null;
            } else {
                OracleTablePartitions.PartitionType tabPartType = otp.getPartitionType();
                type = isComposite ? OracleIndexPartitions.PartitionType.LOCAL_COMP : (tabPartType == OracleTablePartitions.PartitionType.HASH ? OracleIndexPartitions.PartitionType.LOCAL_HASH : OracleIndexPartitions.PartitionType.LOCAL_OTHER);
            }
        }
        return type;
    }

    @Override
    protected Collection getAllowedValues() {
        ArrayList<IndexPartitionTypeComboItem> retval = new ArrayList<IndexPartitionTypeComboItem>();
        Index index = (Index)this.getUpdatedObject();
        Table table = (Table)DBUtil.findParentOfType((DBObject)index, Table.class);
        boolean hasTablePartitions = table != null && Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (index.getIndexType() == Index.IndexType.DOMAIN || index.getIndexType() == Index.IndexType.BITMAP) {
            retval.add(IndexPartitionTypeComboItem.NONE);
            if (hasTablePartitions) {
                retval.add(IndexPartitionTypeComboItem.LOCAL);
            }
        } else if (table != null) {
            for (IndexPartitionTypeComboItem item : IndexPartitionTypeComboItem.values()) {
                if (oip == null && !hasTablePartitions && item.isLocal()) continue;
                retval.add(item);
            }
        }
        return retval;
    }

    @Override
    protected ListCellRenderer getRenderer() {
        return null;
    }

    private OracleIndexPartitions getPartitions() {
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip == null) {
            oip = (OracleIndexPartitions)this.getProvider().getObjectFactory().newObject(OracleIndexPartitions.class, (DBObject)index);
        }
        return oip;
    }

    private class TypeComboListener
    implements ItemListener {
        private TypeComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && IndexPartitionTypePropertyWrapper.this.isActive() && IndexPartitionTypePropertyWrapper.this.getPartitions() != null) {
                OracleIndexPartitions partitions = IndexPartitionTypePropertyWrapper.this.getPartitions();
                if (partitions.getParent() == null) {
                    ComponentContext parentCC = IndexPartitionTypePropertyWrapper.this.getComponentContext().getParentComponentContext();
                    partitions.setParent(parentCC.getUpdatedObject());
                }
                DBObject parent = partitions.getParent();
                IndexPartitionTypeComboItem type = (IndexPartitionTypeComboItem)((Object)e.getItem());
                OracleIndexPartitions current = (OracleIndexPartitions)parent.getProperty("OracleIndexPartitions");
                OracleIndexPartitions toSet = partitions;
                if (current != null && type == IndexPartitionTypeComboItem.NONE) {
                    toSet = null;
                } else if (type != IndexPartitionTypeComboItem.LOCAL) {
                    partitions.setPartitions(new IndexPartition[0]);
                }
                parent.setProperty("OracleIndexPartitions", (Object)toSet);
                IndexPartitionTypePropertyWrapper.this.fireChangeEvent();
            }
        }
    }

    private static enum IndexPartitionTypeComboItem {
        NONE(UIBundle.get("INDEX_PARTITIONS_LIST_NONE"), false),
        GLOBAL_RANGE(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_RANGE"), false),
        GLOBAL_HASH(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_HASH"), false),
        LOCAL(UIBundle.get("INDEX_PARTITIONS_LIST_LOCAL"), true);

        private final String m_text;
        private final boolean m_local;

        private IndexPartitionTypeComboItem(String text, boolean local) {
            this.m_text = text;
            this.m_local = local;
        }

        public String toString() {
            return this.m_text;
        }

        public boolean isLocal() {
            return this.m_local;
        }
    }
}

