/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.components.AsynchronousComboComponentWrapper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class IndexObjectComponentWrapper
extends AsynchronousComboComponentWrapper<CustomCombo> {
    public IndexObjectComponentWrapper() {
        super(new CustomCombo());
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.setParent(this);
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        if (DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Index.class) != null) {
            JComboBox comp = (JComboBox)this.getActiveComponent();
            comp.setEditable(true);
        }
    }

    @Override
    public Object getPropertyValue() {
        JComboBox combo = (JComboBox)this.getActiveComponent();
        Object retval = combo.isEditable() ? combo.getEditor().getItem() : combo.getSelectedItem();
        return retval;
    }

    @Override
    protected void setPropertyValueImpl(Object val) {
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.reset();
        comp.setSelectedItem(val);
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        ((CustomCombo)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexObjectComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void setActiveImpl(boolean active) {
        super.setActiveImpl(active);
        if (!active) {
            ((CustomCombo)this.getActiveComponent()).cancel();
        }
    }

    static class CustomCombo
    extends AbstractLazyCombo {
        private ComponentWrapper m_parent = null;

        CustomCombo() {
        }

        @Override
        public void setName(String name) {
            super.setName(name + "-combo");
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().setName(name);
            }
        }

        private void setParent(ComponentWrapper parent) {
            this.m_parent = parent;
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.m_parent != null) {
                ComponentContext ctx = this.m_parent.getComponentContext();
                DBEditorConfig indexEditorConfig = ctx.getEditorConfig();
                DBObjectProvider pro = ctx.getProvider();
                SystemObject obj = indexEditorConfig.getUpdatedObject();
                Relation table = (Relation)DBUtil.findParentOfType((DBObject)obj, Table.class);
                if (table != null) {
                    for (Column col : table.getColumns()) {
                        ret.add(pro.getExternalName(col.getName(), "COLUMN"));
                    }
                }
            }
            return ret;
        }
    }
}

