/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousComboComponentWrapper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsageEditableWrapper
extends AsynchronousComboComponentWrapper<JComboBox<String>> {
    private final Map<String, DataTypeUsage> m_cache = new ConcurrentHashMap<String, DataTypeUsage>();
    private final Map<String, String> m_defaultUsageStrings = new HashMap<String, String>();

    public DataTypeUsageEditableWrapper() {
        super(new JComboBox());
        JComboBox box = (JComboBox)this.getActiveComponent();
        box.setEditable(true);
        box.setEditor(new BasicComboBoxEditor(){

            @Override
            public void setItem(Object obj) {
                String text = "";
                if (obj instanceof String) {
                    text = (String)obj;
                    String ddl = (String)DataTypeUsageEditableWrapper.this.m_defaultUsageStrings.get(text);
                    if (ddl != null) {
                        text = ddl;
                    }
                }
                if (ModelUtil.areDifferent((Object)this.editor.getText(), (Object)text)) {
                    this.editor.setText(text);
                }
            }

            @Override
            public Object getItem() {
                return super.getItem();
            }
        });
    }

    @Override
    protected void resourceComponent(DBUIResourceHelper resHelp) {
        super.resourceComponent(resHelp);
        resHelp.setName(((JComboBox)this.getActiveComponent()).getEditor().getEditorComponent(), this.getPropertyName() + "-editor");
    }

    @Override
    protected void initialiseComponent() {
        JComboBox combo = (JComboBox)this.getActiveComponent();
        if (this.getComponentContext().isInTable()) {
            combo.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        DataType[] types = this.getProvider().listSupportedDataTypes();
        Arrays.sort(types, DBUtil.getNameComparator());
        NonNullableComboBoxModel model = new NonNullableComboBoxModel();
        for (DataType type : types) {
            String ddl;
            String name = type.getName();
            model.addElement((Object)name);
            DataTypeUsage dtu = type.createDefaultUsage();
            this.m_cache.put(name, dtu);
            if (dtu.getAttributeValues().isEmpty() || !ModelUtil.areDifferent((Object)(ddl = type.getDDL(dtu)), (Object)name)) continue;
            this.m_defaultUsageStrings.put(name, ddl);
            this.m_cache.put(ddl, dtu);
        }
        combo.setModel(model);
    }

    public DataTypeUsage getPropertyValue() {
        String text = (String)((JComboBox)this.getActiveComponent()).getEditor().getItem();
        DataTypeUsage retval = this.m_cache.get(text);
        if (retval == null) {
            retval = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.getProvider(), (Schema)DBUtil.getSchema((DBObject)this.getUpdatedObject()), (String)text);
            if (retval != null) {
                this.m_cache.put(text, (DataTypeUsage)retval.copyTo(null));
            }
        } else {
            retval = (DataTypeUsage)retval.copyTo(null);
        }
        return retval;
    }

    @Override
    protected void setPropertyValueImpl(Object val) {
        JComboBox combo = (JComboBox)this.getActiveComponent();
        String text = "";
        if (val instanceof DataTypeUsage) {
            text = DataTypeHelper.getDDL((DataTypeUsage)((DataTypeUsage)val), (DBObjectProvider)this.getProvider());
        }
        combo.setSelectedItem(text);
    }
}

