/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;

public abstract class AsynchronousDocumentComponentWrapper<T extends JComponent>
extends AsynchronousComponentWrapper<T> {
    private final DocumentListener m_listener = new AsynchronousDocumentListener();
    private boolean m_listening;

    public AsynchronousDocumentComponentWrapper(T component) {
        super(component);
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        this.addDocumentListener(this.getDocument());
    }

    protected final void addDocumentListener(Document doc) {
        if (doc != null) {
            doc.removeDocumentListener(this.m_listener);
            doc.addDocumentListener(this.m_listener);
        }
    }

    protected abstract Document getDocument();

    @Override
    public final void setPropertyValue(Object val) {
        boolean wasListening = this.m_listening;
        this.m_listening = false;
        try {
            this.setPropertyValueImpl(val);
        }
        finally {
            this.m_listening = wasListening;
        }
    }

    protected abstract void setPropertyValueImpl(Object var1);

    protected boolean isListenOnFocusOnly() {
        return true;
    }

    @Override
    protected void gainingFocus() {
        if (this.isListenOnFocusOnly()) {
            this.m_listening = true;
        }
    }

    @Override
    protected void losingFocus() {
        if (this.isListenOnFocusOnly()) {
            this.m_listening = false;
        }
    }

    private void processUpdate(DocumentEvent evt) {
        if (this.m_listening && this.isActive() && evt.getLength() != 0) {
            this.documentChanged(evt);
        }
    }

    protected void documentChanged(DocumentEvent evt) {
        this.markDirty();
    }

    @Override
    protected void setActiveImpl(boolean active) {
        super.setActiveImpl(active);
        if (active) {
            if (!this.isListenOnFocusOnly()) {
                this.m_listening = true;
            }
        } else {
            this.m_listening = false;
        }
    }

    private class AsynchronousDocumentListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AsynchronousDocumentComponentWrapper.this.processUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AsynchronousDocumentComponentWrapper.this.processUpdate(e);
        }
    }
}

