/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class PlSqlGutterPlugin
implements EditorPlugin,
GutterColumnListener {
    private static final String COLUMN_NAME = "PLSQL_IMPLEMENTATIONS";
    private static final String RECALCULATE = "oracle.ideimpl.db.ceditor.PlSqlGutterPlugin.RECALCULATE";
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator((String)PlSqlGutterPlugin.class.getName());
    private final ViewListener m_viewListener = new ViewListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewActivated(ViewEvent e) {
            if (PlSqlGutterPlugin.this.m_column != null) {
                if (PlSqlGutterPlugin.this.m_done) {
                    BaseDBObjectTextNode companionNode;
                    BaseDBObjectTextNode node = PlSqlGutterPlugin.this.getTextNode();
                    try {
                        companionNode = DBObjectNodeUtil.getCompanionNode(node);
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger((Object)this).warning(dbe.getMessage());
                        companionNode = null;
                    }
                    Integer changeId = null;
                    if (companionNode != null) {
                        try {
                            TextBuffer tb = companionNode.acquireTextBuffer();
                            changeId = tb.getChangeId();
                        }
                        finally {
                            companionNode.releaseTextBuffer();
                        }
                    }
                    if (ModelUtil.areDifferent((Object)PlSqlGutterPlugin.this.m_companionChangeID, changeId)) {
                        PlSqlGutterPlugin.this.m_done = false;
                        PlSqlGutterPlugin.this.m_companionChangeID = changeId;
                    }
                }
                if (!PlSqlGutterPlugin.this.m_done) {
                    PlSqlGutterPlugin.this.propertyChange(new PropertyChangeEvent(this, PlSqlGutterPlugin.RECALCULATE, true, false));
                    PlSqlGutterPlugin.this.m_done = true;
                }
            }
        }

        public void viewDeactivated(ViewEvent e) {
        }

        public void viewClosed(ViewEvent e) {
        }
    };
    private BasicEditorPane m_editor;
    private GutterColumn m_column;
    private boolean m_done;
    private Integer m_companionChangeID;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane editor) {
        if (PlSqlFeatures.isSupportedGutterNavigation()) {
            CodeEditor.getCodeEditor((BasicEditorPane)editor).addViewListener(this.m_viewListener);
            this.m_editor = editor;
            BaseDBObjectTextNode node = this.getTextNode();
            if (node != null && node.getProvider() != null && this.isSupportedType(node.getObjectType())) {
                CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)this.m_editor).getGutter();
                this.m_column = gutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.m_column != null) {
            CodeEditorGutter gutter;
            if (this.m_reqProc != null) {
                this.m_reqProc.cancel(this.getRequestProcessorKey());
                this.m_reqProc = null;
            }
            if ((gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter()) != null) {
                gutter.removeGutterColumn(this.m_column);
            }
            CodeEditor.getCodeEditor((BasicEditorPane)editor).removeViewListener(this.m_viewListener);
            this.m_column = null;
            this.m_editor = null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_column != null && (RECALCULATE.equals(evt.getPropertyName()) || "compoundEditInProgress".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getOldValue()) && Boolean.FALSE.equals(evt.getNewValue()))) {
            BaseDBObjectTextNode node = this.getTextNode();
            if (this.m_reqProc == null) {
                this.m_reqProc = DBRequestProcessorFactory.getProcessor(node);
            }
            String string = this.getRequestProcessorKey();
            DBRequestProcessor dBRequestProcessor = this.m_reqProc;
            dBRequestProcessor.getClass();
            this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, node.getProvider(), UIBundle.format("PLSQL_GUTTER_TASK", node.getShortLabel())){
                {
                    DBRequestProcessor dBRequestProcessor = x0;
                    dBRequestProcessor.getClass();
                    super(pro, name);
                }

                @Override
                protected void doWork() throws DBException {
                    PlSqlGutterPlugin.this.updateGutter();
                }
            }, 1500);
        }
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        try {
            Tuple data = (Tuple)gutterMark.getUserData();
            BaseDBObjectTextNode otherNode = (BaseDBObjectTextNode)data.object1();
            boolean gotoOffset = false;
            if (otherNode != null && !(gotoOffset = otherNode.isOpen())) {
                gotoOffset = otherNode.getDBObject() instanceof PlSqlSchemaObject;
            }
            if (gotoOffset) {
                Integer startOffset = (Integer)data.object2();
                Context c = Context.newIdeContext((Node)otherNode);
                OffsetNavigationPoint point = new OffsetNavigationPoint(c, startOffset.intValue(), 0);
                point.setPreferredEditorType(null);
                NavigationManager mgr = NavigationManager.getNavigationManager();
                if (mgr != null) {
                    mgr.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            } else {
                this.clearGutter();
            }
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(DBLog.getExceptionLogLevel(), "Error in Go to Source for pl/sql", e);
        }
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        String otherType;
        BaseDBObjectTextNode node = this.getTextNode();
        DBObject nodeObj = node.getDBObject();
        if (nodeObj instanceof PlSqlSchemaObject && (otherType = PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)((PlSqlSchemaObject)nodeObj))) != null) {
            return UIBundle.format("PLSQL_GUTTER_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(otherType));
        }
        return null;
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.m_editor);
    }

    private boolean isSupportedType(String type) {
        return "PACKAGE".equals(type) || "PACKAGE BODY".equals(type) || "TYPE".equals(type) || "TYPE BODY".equals(type);
    }

    private void clearGutter() {
        GutterColumn column = this.m_column;
        if (column != null) {
            column.removeAllGutterMarks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGutter() throws CancelledException {
        if (this.m_column != null) {
            Runnable later = null;
            BaseDBObjectTextNode node = this.getTextNode();
            DBObjectProvider pro = node.getProvider();
            String timestampKey = s_tsKeyGen.next();
            try {
                List list;
                PlSqlSourceObject otherObject;
                BaseDBObjectTextNode otherNode;
                DBUtil.suspendTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
                PlSqlSourceObject so = (PlSqlSourceObject)node.getDBObjectFromBuffer();
                if (so instanceof PlSqlSchemaObject && (otherNode = DBObjectNodeUtil.getCompanionNode(node)) != null && (otherObject = (PlSqlSourceObject)otherNode.getDBObjectFromBuffer()) != null && (list = PlSqlUtil.getTopLevelPlSqlFragments((DBObjectProvider)pro, (PlSqlSchemaObject)((PlSqlSchemaObject)so), (PlSqlSchemaObject)((PlSqlSchemaObject)otherObject))) != null) {
                    Icon icon = so instanceof PlSqlSchemaObjectSpec ? OracleIcons.getIcon((String)"gutter/down.png") : OracleIcons.getIcon((String)"gutter/up.png");
                    later = () -> this.updateGutterUI(list, icon, otherNode);
                }
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).warning(dbe.getMessage());
            }
            finally {
                DBUtil.resumeTimestampChecking((DBObjectProvider)pro, (String)timestampKey);
            }
            if (later == null) {
                later = () -> this.clearGutter();
            }
            SwingUtilities.invokeLater(later);
        }
    }

    private void updateGutterUI(List<Tuple<PlSqlSubProgram, PlSqlSubProgram>> list, Icon icon, BaseDBObjectTextNode otherNode) {
        this.clearGutter();
        if (this.m_column != null) {
            for (Tuple<PlSqlSubProgram, PlSqlSubProgram> pair : list) {
                int options;
                int line;
                GutterMark mark;
                PlSqlSubProgram frag1 = (PlSqlSubProgram)pair.getFirst();
                PlSqlSubProgram frag2 = (PlSqlSubProgram)pair.getSecond();
                if (frag1 == null || frag2 == null || (mark = this.m_column.addGutterMark(line = this.getTextNode().getLine(frag1.getStartOffset()), icon, null, 3000, options = 1)) == null) continue;
                mark.setUserData((Object)new Tuple((Object)otherNode, (Object)frag2.getStartOffset()));
            }
        }
    }
}

