/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ideimpl.db.ceditor.PlSqlFoldingBlock;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.token.Token;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel<PlSqlFoldingBlock> {
    private final String m_eol;
    private final BaseDBObjectTextNode m_node;
    private LineMap m_map;
    private final Collection<Integer> m_collapsedOffsets = new HashSet<Integer>();
    private final CodeFoldingMargin m_margin;
    private PlSqlParser m_parser;

    public PlSqlFoldingModel(BasicDocument document, BaseDBObjectTextNode node, CodeFoldingMargin margin) {
        super(document);
        TextBuffer buffer = document.getTextBuffer();
        this.m_eol = buffer.getEOLType();
        this.m_node = node;
        this.m_margin = margin;
        this.setRoot(new PlSqlFoldingBlock());
        this.resetRoot();
    }

    final void resetRoot() {
        DBRequestProcessor reqProc = DBRequestProcessorFactory.getProcessor(this.m_node);
        String string = this.getRequestProcessorKey();
        DBRequestProcessor dBRequestProcessor = reqProc;
        dBRequestProcessor.getClass();
        reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, this.m_node.getProvider(), UIBundle.format("PLSQL_FOLDING_TASK", this.m_node.getShortLabel())){
            {
                DBRequestProcessor dBRequestProcessor = x0;
                dBRequestProcessor.getClass();
                super(pro, name);
            }

            @Override
            protected void doWork() throws DBException {
                PlSqlFoldingModel.this.resetRootImpl();
            }
        }, 1500);
    }

    private void resetRootImpl() throws CancelledException {
        PlSqlParser parser;
        boolean skip;
        TextBuffer buff = this.m_node.acquireTextBuffer();
        this.m_map = buff == null ? null : buff.getLineMap();
        PlSqlSourceObject so = (PlSqlSourceObject)this.m_node.getDBObjectFromBuffer();
        boolean bl = skip = so == null;
        if (!skip && this.getRoot() != null) {
            parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)this.m_node.getProvider());
            skip = parser == null || !parser.getIssues().isEmpty();
        } else {
            parser = null;
        }
        if (!skip && this.m_map != null) {
            this.m_parser = parser;
            DefaultFoldingBlock[] collapsed = this.getCollapsedBlocks();
            this.m_collapsedOffsets.clear();
            for (int i = 0; i < collapsed.length; ++i) {
                this.m_collapsedOffsets.add(collapsed[i].getStartOffset());
            }
            if (parser != null) {
                int start = parser.getStartOffsetOfObject();
                int end = parser.getEndOffsetOfObject();
                Object rootParseNode = parser.getParseNode(start);
                final PlSqlFoldingBlock block = new PlSqlFoldingBlock();
                this.populateFoldingBlock(block, rootParseNode, start, end);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PlSqlFoldingModel.this.setRoot(block);
                    }
                });
            }
        }
    }

    private void populateFoldingBlock(PlSqlFoldingBlock block, Object parseNode, int start, int end) throws CancelledException {
        block.setUserObject(parseNode);
        block.setStartOffset(start);
        block.setEndOffset(end);
        int endOfLine1 = this.m_map.getLineEndOffset(this.m_map.getLineFromOffset(start));
        if (endOfLine1 > end) {
            endOfLine1 = end;
        }
        PlSqlToken tk1 = this.m_parser.getTokenAtOffset(start);
        PlSqlToken tk2 = this.m_parser.getTokenAtOffset(endOfLine1);
        if (tk1 != null && tk2 != null) {
            if (!tk2.isCode()) {
                tk2 = (PlSqlToken)tk2.getPrevCodeToken();
            }
            block.setReplacementText(tk1.getSource(false, (Token)tk2) + "...");
        }
    }

    public Iterator getChildren(PlSqlFoldingBlock block) {
        Object parseNode;
        if (!block.isChildrenLoaded() && (parseNode = block.getUserObject()) != null) {
            try {
                this.addChildren(block, parseNode);
                block.setChildrenLoaded(true);
            }
            catch (CancelledException e) {
                DBLog.getLogger((Object)((Object)this)).fine(e.getMessage());
            }
        }
        return block.getChildren();
    }

    private void addChildren(PlSqlFoldingBlock block, Object parseNode) throws CancelledException {
        int parsentStartLine = this.m_map.getLineFromOffset(this.m_parser.getStartOffset(parseNode));
        for (Object child : this.m_parser.getChildParseNodes(null, parseNode)) {
            int start = this.m_parser.getStartOffset(child);
            int startLine = this.m_map.getLineFromOffset(start);
            int end = this.m_parser.getEndOffset(child);
            int endLine = this.m_map.getLineFromOffset(end);
            PlSqlToken tk = this.m_parser.getTokenAtOffset(start);
            if (this.isAlwaysFold(tk) || startLine != parsentStartLine && endLine > startLine + 5) {
                PlSqlFoldingBlock childBlock = new PlSqlFoldingBlock();
                this.populateFoldingBlock(childBlock, child, start, end);
                block.add((FoldingBlock)childBlock);
                if (!this.m_collapsedOffsets.contains(this.m_parser.getStartOffset(child))) continue;
                this.m_margin.setExpansionState((Object)childBlock, false);
                continue;
            }
            this.addChildren(block, child);
        }
    }

    private boolean isAlwaysFold(PlSqlToken tk) {
        return tk != null && (tk.matches("IF") || tk.matches("ELSIF") || tk.matches("ELSE") || tk.matches("WHILE") || tk.matches("FOR") || tk.matches("LOOP"));
    }

    private String getRequestProcessorKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

