/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.PeekHelper;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumb;
import oracle.ideimpl.db.ceditor.PlSqlBreadcrumbsModel;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;

public final class PlSqlBreadcrumbsPlugin
extends BreadcrumbsPlugin
implements CaretListener {
    private PlSqlBreadcrumbsListener m_listener;
    private PlSqlBreadcrumbsModel m_breadcrumbsModel;
    private PopupHandler m_popupHandler;
    private DBRequestProcessor m_reqProc;

    public void install(BasicEditorPane editor) {
        Preferences preferences = Preferences.getPreferences();
        if (DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs() && PlSqlFeatures.isSupportedBreadcrumbs() && PlSqlFeatures.getTextNode(editor) != null) {
            super.install(editor);
            editor.addCaretListener((CaretListener)this);
            this.m_breadcrumbsModel = new PlSqlBreadcrumbsModel();
            this.breadcrumbs.setModel((BreadcrumbsModel)this.m_breadcrumbsModel);
            this.m_listener = new PlSqlBreadcrumbsListener();
            this.breadcrumbs.addBreadcrumbsListener((BreadcrumbsListener)this.m_listener);
            this.m_popupHandler = new PopupHandler();
            this.m_popupHandler.attach(this.breadcrumbs, (PopupProvider)new PlSqlPopupProvider());
        }
    }

    public void deinstall(BasicEditorPane editor) {
        DBRequestProcessor reqProc;
        PlSqlBreadcrumbsModel breadcrumbsModel;
        PlSqlBreadcrumbsListener listener;
        PopupHandler popupHandler = this.m_popupHandler;
        if (popupHandler != null) {
            popupHandler.detatch();
            this.m_popupHandler = null;
        }
        if ((listener = this.m_listener) != null) {
            this.breadcrumbs.removeBreadcrumbsListener((BreadcrumbsListener)listener);
            this.m_listener = null;
        }
        if ((breadcrumbsModel = this.m_breadcrumbsModel) != null) {
            breadcrumbsModel.dispose();
            this.breadcrumbs.setModel(null);
            this.m_breadcrumbsModel = null;
        }
        if ((reqProc = this.m_reqProc) != null) {
            reqProc.cancel(this.getRequestProcessorKey());
            this.m_reqProc = null;
        }
        editor.removeCaretListener((CaretListener)this);
        super.deinstall(editor);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        BaseDBObjectTextNode node = this.getTextNode();
        if (this.m_reqProc == null) {
            this.m_reqProc = DBRequestProcessorFactory.getProcessor(node);
        }
        String string = this.getRequestProcessorKey();
        DBRequestProcessor dBRequestProcessor = this.m_reqProc;
        dBRequestProcessor.getClass();
        this.m_reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, node.getProvider(), UIBundle.format("PLSQL_BREADCRUMBS_TASK", node.getShortLabel())){
            {
                DBRequestProcessor dBRequestProcessor = x0;
                dBRequestProcessor.getClass();
                super(pro, name);
            }

            @Override
            protected void doWork() throws DBException {
                PlSqlBreadcrumbsPlugin.this.updateBreadCrumbs();
            }
        }, 1500);
    }

    private BaseDBObjectTextNode getTextNode() {
        return PlSqlFeatures.getTextNode(this.editor);
    }

    private String getRequestProcessorKey() {
        return this.getClass().getSimpleName();
    }

    private void updateBreadCrumbs() throws CancelledException {
        PlSqlCodeFragment frag;
        PlSqlParser parser;
        BaseDBObjectTextNode node;
        PlSqlSourceObject so;
        PlSqlBreadcrumbsModel breadcrumbsModel = this.m_breadcrumbsModel;
        if (breadcrumbsModel != null && (so = (PlSqlSourceObject)(node = this.getTextNode()).getDBObjectFromBuffer()) != null && (parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)so, (DBObjectProvider)this.getTextNode().getProvider())) != null && parser.getRoot() != null && this.editor != null && breadcrumbsModel != null && breadcrumbsModel.update(frag = (PlSqlCodeFragment)so.getDeclarationAtOffset(this.editor.getCaretPosition()), parser)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlSqlBreadcrumbsModel bcm = PlSqlBreadcrumbsPlugin.this.m_breadcrumbsModel;
                    if (bcm != null) {
                        bcm.fireBreadcrumbsUpdated();
                    }
                }
            });
        }
    }

    private class PlSqlBreadcrumbsListener
    implements BreadcrumbsListener<Integer> {
        private CodePeek m_peek;

        private PlSqlBreadcrumbsListener() {
        }

        public void breadcrumbClicked(Breadcrumb<Integer> crumb) {
            if (crumb != null) {
                PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)crumb.getUserObject()).intValue());
                PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
            }
        }

        public void breadcrumbContextClicked(Breadcrumb<Integer> crumb, Point p) {
        }

        public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
            String peekText;
            if (crumb == null) {
                return;
            }
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
            if ((peekText = ((PlSqlBreadcrumb)crumb).getPeekText()) == null) {
                return;
            }
            this.m_peek = PeekHelper.createCodePeek((JComponent)PlSqlBreadcrumbsPlugin.this.breadcrumbs, (String)PlSqlBreadcrumbsPlugin.this.getTextNode().getURL().toExternalForm(), (String)peekText, null, (Rectangle)peekLocation);
            this.m_peek.getGhostPointingPalette().setShowRectangle(false);
            this.m_peek.showPeek();
        }

        public void hideBreadcrumbPeek() {
            if (this.m_peek != null) {
                this.m_peek.hidePeek();
            }
        }

        public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
        }
    }

    private class PlSqlPopupProvider
    implements PopupProvider<Integer> {
        private PlSqlPopupProvider() {
        }

        public List<PopupItem> getPopupItems(Breadcrumb breadcrumb) {
            List<PopupItem> itemList = ((PlSqlBreadcrumb)breadcrumb).getPopupItems();
            return itemList;
        }

        public void itemSelected(PopupItem<Integer> popupItem) {
            PlSqlBreadcrumbsPlugin.this.editor.setCaretPositionCenter(((Integer)popupItem.getUserObject()).intValue());
            PlSqlBreadcrumbsPlugin.this.editor.requestFocus();
        }
    }
}

