/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import oracle.ide.Addin;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Element;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.DropHelper;
import oracle.ideimpl.db.DBObjectActionsController;
import oracle.ideimpl.db.ProgressBarExecutionWrapper;
import oracle.ideimpl.db.editors.DBObjectNavigationPoint;
import oracle.ideimpl.db.editors.DBObjectOverviewEditor;
import oracle.ideimpl.db.model.DatabaseDragHelper;
import oracle.ideimpl.db.model.DatabaseDropHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.execute.StatementWrapper;

public class DatabaseIdeAddin
implements Addin {
    public static final String EXTENSION_ID = "oracle.ide.db";
    private static final DBObjectActionsController s_controller = new DBObjectActionsController();

    public void initialize() {
        StatementWrapper.setExecutionProxy((StatementWrapper.ExecutionProxy)new ProgressBarExecutionWrapper());
        DatabaseIdeAddin.registerController();
        NavigationManager.getNavigationManager().registerEditorNavigationPoint(DBObjectNavigationPoint.class, DBObjectOverviewEditor.class);
        DialogUtil.addURLFilter((URLFilter)SqlNode.SQL_FILTER);
        DialogUtil.addURLFilter((URLFilter)new DefaultURLFilter(UIBundle.get("PLSQL_URLFILTER_TEXT"), new String[]{".pls", ".pks", ".pkb"}));
        DragDropManager ddMgr = DragDropManager.getInstance();
        if (ddMgr != null) {
            DatabaseDragHelper dragHelper = new DatabaseDragHelper();
            ddMgr.registerDragHelperForInstance((DragHelper)dragHelper, DBObjectNode.class);
            ddMgr.registerDropHelperForInstance((DropHelper)new DatabaseDropHelper(), Element.class);
        }
    }

    public static void registerController() {
        DatabaseIdeAddin.addController(DBObjectActions.getPropertiesAction());
        DatabaseIdeAddin.addController(IdeActions.getViewRefreshAction());
    }

    private static void addController(IdeAction action) {
        action.removeController((Controller)s_controller);
        action.addController((Controller)s_controller);
    }
}

