/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.util.Holder;
import oracle.javatools.util.MultiMap;

public class SchemaObjectBuilder {
    private boolean m_cancellable;
    private DBObjectProvider m_pro;
    private MultiMap<String, String> m_props;

    public SchemaObjectBuilder(boolean cancellable) {
        this.m_cancellable = cancellable;
    }

    public void buildDerivedProperties(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setProperties(String type, String ... props) {
        if (this.m_props == null) {
            this.m_props = new MultiMap();
        }
        this.m_props.remove((Object)type);
        if (props != null) {
            for (String prop : props) {
                if (prop == null) continue;
                this.m_props.add((Object)type, (Object)prop);
            }
        }
    }

    private String[] getPropertiesToBuild(String type) {
        String[] retval = null;
        if (this.m_props != null) {
            Collection typeProps;
            TreeSet retvalCol = new TreeSet();
            Collection allProps = this.m_props.get(null);
            if (allProps != null) {
                retvalCol.addAll(allProps);
            }
            if ((typeProps = this.m_props.get((Object)type)) != null) {
                retvalCol.addAll(typeProps);
            }
            if (retvalCol.size() > 0) {
                retval = retvalCol.toArray(new String[retvalCol.size()]);
            }
        }
        return retval;
    }

    public boolean ensureObjectBuilt(DBObject ... objs) {
        try {
            return this.ensureObjectBuiltEx(objs);
        }
        catch (CancelledException cancelledException) {
        }
        catch (DBException dbe) {
            DBObject obj = dbe.getObject();
            String title = obj == null ? UIBundle.get("EXEC_BUILD_ERR_TITLE2") : UIBundle.format("EXEC_BUILD_ERR_TITLE", obj.getName());
            DBExceptionDialog.showErrorDialog((Component)IdeUtil.getMainWindow(), title, dbe);
        }
        return false;
    }

    public boolean ensureObjectBuiltEx(DBObject ... objs) throws DBException, CancelledException {
        if (objs != null && objs.length > 0) {
            this.ensureObjectBuiltImpl(objs);
            return true;
        }
        return false;
    }

    @Deprecated
    public void ensureDerivedPropertiesBuiltEx(DBObject obj) throws DBException {
        if (obj != null) {
            this.ensureObjectBuiltImpl(obj);
        }
    }

    private Collection<DBObject> getObjectsToBuild(DBObject ... objs) {
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        for (DBObject obj : objs) {
            if ((!(obj instanceof SystemObject) || !this.needsBuilding((SystemObject)obj)) && (this.m_pro == null || !DBUtil.needsDerivedPropertiesBuilding((DBObjectProvider)this.m_pro, (DBObject)obj))) continue;
            retval.add(obj);
        }
        return retval;
    }

    private boolean needsBuilding(SystemObject obj) {
        boolean retval = false;
        if (DBUtil.needsBuilding((DBObject)obj)) {
            String[] props = this.getPropertiesToBuild(obj.getType());
            if (props == null || props.length == 0) {
                retval = true;
            } else {
                for (String prop : props) {
                    if (!DBUtil.needsBuilding((DBObject)obj, (String)prop)) continue;
                    retval = true;
                    break;
                }
            }
        }
        return retval;
    }

    private String getProgressText(DBObject obj) {
        SystemObject sysObj = DBUtil.getSystemObject((DBObject)obj);
        if (sysObj != null) {
            obj = sysObj;
        }
        return UIBundle.format("EXEC_PB_OBJ_PROGRESS", DBTypeDisplayRegistry.getSingularDisplayName(obj.getType()), obj.getName());
    }

    private void ensureObjectBuiltImpl(DBObject ... objs) throws DBException {
        final Collection<DBObject> toBuild = this.getObjectsToBuild(objs);
        if (toBuild.size() > 0) {
            ProgressBar pb;
            final Holder dbeHolder = new Holder();
            final Holder objHolder = new Holder();
            final Holder builderHolder = new Holder();
            if (SwingUtilities.isEventDispatchThread()) {
                Frame parent = IdeUtil.getMainWindow();
                pb = new ProgressBar((Component)parent, UIBundle.get("EXEC_PB_OBJ_TITLE"), null, true);
                pb.setCancelable(this.m_cancellable);
            } else {
                pb = null;
            }
            final Holder pbThread = new Holder();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block23: {
                        pbThread.set((Object)Thread.currentThread());
                        try {
                            for (DBObject obj : toBuild) {
                                if (pb != null && pb.hasUserCancelled()) {
                                    break;
                                }
                                try {
                                    objHolder.set((Object)obj);
                                    if (pb != null) {
                                        pb.updateProgress(SchemaObjectBuilder.this.getProgressText(obj), null);
                                    }
                                    DerivedPropertyBuilder dpb = null;
                                    if (SchemaObjectBuilder.this.m_pro != null) {
                                        dpb = SchemaObjectBuilder.this.m_pro.getObjectFactory().ensureDerivedPropertyBuilder(obj);
                                    }
                                    boolean buildAll = false;
                                    String[] props = SchemaObjectBuilder.this.getPropertiesToBuild(obj.getType());
                                    if (props == null) {
                                        props = new String[1];
                                        buildAll = true;
                                    }
                                    for (String prop : props) {
                                        if (pb != null && pb.hasUserCancelled()) {
                                            break block23;
                                        }
                                        try {
                                            builderHolder.set((Object)DBUtil.getDBObjectBuilder((DBObject)obj, (String)prop));
                                            DBUtil.ensureObjectBuilt((DBObject)obj, (String[])new String[]{prop});
                                        }
                                        finally {
                                            builderHolder.set(null);
                                        }
                                    }
                                    if (pb != null && pb.hasUserCancelled()) {
                                        break;
                                    }
                                    if (!buildAll || SchemaObjectBuilder.this.m_pro == null || dpb == null) continue;
                                    try {
                                        builderHolder.set((Object)dpb);
                                        DBUtil.ensureDerivedPropertiesBuilt((DBObject)obj, (DBObjectProvider)SchemaObjectBuilder.this.m_pro);
                                    }
                                    catch (DBException dbe) {
                                        DBLog.getLogger((Object)this).log(Level.WARNING, UIBundle.format("EXEC_DERIVED_BUILD_LOG_ERR", DBTypeDisplayRegistry.getSingularDisplayName(obj.getType()), obj.getName(), dbe.getMessage()));
                                    }
                                    finally {
                                        builderHolder.set(null);
                                    }
                                }
                                catch (DBException ex) {
                                    dbeHolder.set((Object)ex);
                                    break;
                                }
                                catch (Throwable t) {
                                    dbeHolder.set((Object)new DBException(obj, t));
                                    break;
                                }
                            }
                        }
                        finally {
                            objHolder.set(null);
                            if (pb != null) {
                                pb.setDoneStatus();
                            }
                        }
                    }
                }
            };
            if (pb == null) {
                r.run();
            } else {
                pb.setRunnable(r);
                DBUIProgressBar.start(pb, this.getProgressText(toBuild.iterator().next()), null);
                if (pb.hasUserCancelled()) {
                    Thread t;
                    DBObjectBuilder builder = (DBObjectBuilder)builderHolder.get();
                    if (builder != null) {
                        builder.cancelCurrentBuild((DBObject)objHolder.get());
                    }
                    if ((t = (Thread)pbThread.get()) != null) {
                        StatementWrapper.cancelExecution((Thread)t);
                    }
                    throw new CancelledException();
                }
            }
            if (dbeHolder.get() != null) {
                throw (DBException)((Object)dbeHolder.get());
            }
        }
    }
}

