/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconWithSmallOverlay
implements Icon {
    private int m_width = -1;
    private int m_height = -1;
    private int m_xOffset = 0;
    private int m_yOffset = 0;
    private Icon m_baseIcon = null;
    private Icon m_overlayIcon = null;

    public IconWithSmallOverlay(Icon baseIcon, Icon overlayIcon) {
        this(baseIcon, overlayIcon, 12, 12, 4, 4);
    }

    public IconWithSmallOverlay(Icon baseIcon, Icon overlayIcon, int width, int height, int xOffset, int yOffset) {
        this.m_baseIcon = baseIcon;
        if (overlayIcon instanceof ImageIcon) {
            Image newImg = ((ImageIcon)overlayIcon).getImage().getScaledInstance(width, height, 4);
            this.m_overlayIcon = new ImageIcon(newImg);
        }
        this.m_xOffset = xOffset;
        this.m_yOffset = yOffset;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.m_baseIcon.paintIcon(c, g, x, y);
        if (this.m_overlayIcon != null) {
            this.m_overlayIcon.paintIcon(c, g, x + this.m_xOffset, y + this.m_yOffset);
        }
    }

    @Override
    public int getIconWidth() {
        if (this.m_width == -1) {
            this.m_width = this.m_baseIcon.getIconWidth();
        }
        return this.m_width;
    }

    @Override
    public int getIconHeight() {
        if (this.m_height == -1) {
            this.m_height = this.m_baseIcon.getIconHeight();
        }
        return this.m_height;
    }
}

