/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.db.panels.sql.tester.MessageTesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.Holder;

class TestSQLPanel
extends MessageTesterComponent {
    private final TesterPanel m_tester;
    private final JTextArea m_txtSQL;

    public TestSQLPanel(JTextArea sqlTxtArea, TesterPanel tester) {
        super("TestSQLPanel", UIBundle.get("TESTSQL_MSG_LABEL"));
        this.m_tester = tester;
        this.m_txtSQL = sqlTxtArea;
    }

    @Override
    public String getName() {
        return UIBundle.get("TESTSQL_TEST");
    }

    @Override
    public void testSQL(Database db, String sqlQuery) {
        this.m_txtSQL.setText(null);
        if (db == null) {
            this.setMessageText(UIBundle.get("TESTSQL_CHOOSE_DB"));
        } else {
            this.runTest(db, sqlQuery);
        }
    }

    @Override
    protected void doTestSQL(Database db, String sqlQuery) {
        final Holder queryTxt = new Holder((Object)sqlQuery);
        final Holder result = new Holder((Object)false);
        final Holder resultTxt = new Holder((Object)UIBundle.get("TESTSQL_SUCCESS"));
        final Holder offset = new Holder();
        try {
            db.testSQLStatement(sqlQuery);
            result.set((Object)true);
        }
        catch (InvalidSQLException sqe) {
            resultTxt.set((Object)sqe.getMessage());
            queryTxt.set((Object)sqe.getSQLWithError());
            offset.set((Object)sqe.getOffset());
        }
        catch (DBException dbe) {
            resultTxt.set((Object)dbe.getMessage());
        }
        this.m_tester.setResult((Boolean)result.get(), (String)resultTxt.get(), (Integer)offset.get());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestSQLPanel.this.m_tester.enableTabs((Boolean)result.get());
                TestSQLPanel.this.setMessageText((String)resultTxt.get());
                String sql = (String)queryTxt.get();
                Integer i = (Integer)offset.get();
                MessageTesterComponent.setText(TestSQLPanel.this.m_txtSQL, sql);
                if (i != null && sql != null) {
                    int end = TestSQLPanel.this.getWordEnd(sql, i);
                    if (end == i) {
                        int caret = sql.indexOf("^", (int)i);
                        if (caret >= 0) {
                            TestSQLPanel.this.m_txtSQL.setCaretPosition(caret);
                        }
                    } else {
                        TestSQLPanel.this.m_txtSQL.setCaretPosition(i);
                        TestSQLPanel.this.m_txtSQL.moveCaretPosition(end + 1);
                    }
                    TestSQLPanel.this.m_txtSQL.requestFocusInWindow();
                }
            }
        });
    }

    private int getWordEnd(String sql, int offset) {
        int retval = offset;
        for (int i = offset; i < sql.length(); ++i) {
            retval = i;
            if (Character.isWhitespace(sql.charAt(i + 1))) break;
        }
        return retval;
    }
}

