/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class NewPlsqlPanel
extends NameAndSchemaEditor<PlSqlSourceObject> {
    private JLabel m_lblType = new JLabel();
    private JComboBox m_cmbType = new JComboBox();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("NewPlsqlPanel");

    public NewPlsqlPanel() {
        this.m_resHelper.resLabel(this.m_lblType, this.m_cmbType, this.getTypeLabel(), "m_cmbType");
    }

    public abstract String getTypeLabel();

    public abstract List getTypeList(PlSqlSourceObject var1);

    public abstract PlSqlComboItem getDefaultComboItem();

    protected abstract void performProcess(PlSqlSourceObject var1, DBObjectProvider var2) throws TraversalException;

    protected final PlSqlComboItem getSelectedType() {
        return (PlSqlComboItem)this.m_cmbType.getSelectedItem();
    }

    @Override
    protected void initialisePanel() {
        if (this.showTypeCombo()) {
            DBObjectProvider pro = this.getProvider();
            PlSqlSourceObject obj = (PlSqlSourceObject)this.getUpdatedObject();
            PlSqlSourceObject origObj = (PlSqlSourceObject)this.getOriginalObject();
            List typeList = this.getTypeList(obj);
            if (typeList != null && typeList.size() > 0) {
                this.m_cmbType.setModel(new DefaultListComboBoxModel(typeList));
                if (typeList.size() < 2) {
                    this.m_lblType.setVisible(false);
                    this.m_cmbType.setVisible(false);
                }
            }
            if (obj instanceof Type && (origObj != null || TemplateExpander.isPendingObject((DBObject)obj))) {
                DBUIProgressBar pb = new DBUIProgressBar(UIBundle.format("BUILDING_COLLECTION_TYPE", obj.getName()));
                final Holder holder = new Holder();
                final Type type = (Type)obj;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        holder.set((Object)type.getCollectionType());
                    }
                };
                pb.execute(runner);
                String collType = (String)holder.get();
                ComboBoxModel model = this.m_cmbType.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    String modelCollType = ((PlSqlComboItem)model.getElementAt(i)).getCollectionType();
                    if (modelCollType.length() == 0) {
                        modelCollType = null;
                    }
                    if (!ModelUtil.areEqual((Object)modelCollType, (Object)collType)) continue;
                    this.m_cmbType.setSelectedIndex(i);
                    this.m_cmbType.setEnabled(false);
                    break;
                }
            } else {
                PlSqlComboItem def = this.getDefaultComboItem();
                if (def != null) {
                    this.m_cmbType.setSelectedItem(def);
                }
            }
        }
        super.initialisePanel();
    }

    private boolean showTypeCombo() {
        return !this.getEditorConfig().isInFlatEditor();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.showTypeCombo()) {
            this.performProcess((PlSqlSourceObject)this.getUpdatedObject(), this.getProvider());
        }
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper layout) {
        super.layoutComponents(layout);
        if (this.showTypeCombo()) {
            layout.nextRow();
            layout.add(this.m_lblType);
            layout.add(this.m_cmbType);
        }
    }

    protected final class PlSqlComboItem {
        private String m_display;
        private String m_plsql;
        private String m_extraPlsql;
        private String m_type;
        private String m_collType;

        public PlSqlComboItem(String type, String display, String plsql) {
            this(type, display, plsql, null, "");
        }

        public PlSqlComboItem(String type, String display, String plsql, String extraPlsql, String collType) {
            this.m_type = type;
            this.m_display = display;
            this.m_plsql = plsql;
            this.m_extraPlsql = extraPlsql;
            this.m_collType = collType;
        }

        public String getType() {
            return this.m_type;
        }

        public String getDisplayString() {
            return this.m_display;
        }

        public String getPlsql() {
            return this.m_plsql;
        }

        public String getExtraPlsql() {
            return this.m_extraPlsql;
        }

        public boolean isCollectionType() {
            return !this.m_collType.equals("");
        }

        public String getCollectionType() {
            return this.m_collType;
        }

        public String toString() {
            return UIBundle.get(this.getDisplayString());
        }
    }
}

