/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBDialogHeader;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class SelectSchemaPanel
extends DefaultTraversablePanel {
    public static final String USE_DEFAULT_KEY = "USE_DEFAULT";
    private final JLabel m_lblSchemaName = new JLabel();
    private final DBObjectChooser m_pickerSchema = new DBObjectChooser("SCHEMA");
    private final JCheckBox m_useDefault = new JCheckBox();
    private final ItemListener m_listener = new CheckBoxListener();
    private DBObjectProvider m_prov = null;
    private DBObjectID m_previous = null;

    public SelectSchemaPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SelectSchemaPanel");
        reshelp.resLabel(this.m_lblSchemaName, this.m_pickerSchema, UIBundle.get("SCHEMA_INFO_LABEL_SCHEMA_NAME"), "Schema");
        ResourceUtils.resButton((AbstractButton)this.m_useDefault, (String)UIBundle.get("SCHEMA_USE_DEFAULT"));
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_pickerSchema, new GridBagConstraints(20, 10, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_useDefault, new GridBagConstraints(20, 20, 17, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIBundle.get("SCHEMA_HEADER");
    }

    public String getHeaderDescription() {
        return UIBundle.get("SCHEMA_HEADER_DESC");
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider provider;
        this.m_prov = provider = (DBObjectProvider)dataContext.find("oracle.javatools.db.DBObjectProvider");
        Schema schema = (Schema)dataContext.find("NewObject");
        if (schema != null) {
            this.m_previous = schema.getID();
        }
        boolean useDefault = Boolean.TRUE == dataContext.find(USE_DEFAULT_KEY);
        this.m_pickerSchema.setProvider(provider);
        this.m_pickerSchema.setDBObject((DBObject)schema);
        this.m_pickerSchema.setNullText("");
        this.m_useDefault.removeItemListener(this.m_listener);
        this.m_useDefault.setSelected(useDefault);
        this.m_useDefault.addItemListener(this.m_listener);
        this.enablePicker(useDefault);
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        if (callbacks != null) {
            callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            callbacks.wizardSetInitialFocus((Component)(this.m_pickerSchema.isEnabled() ? this.m_pickerSchema : this.m_useDefault));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.remove("NewObject");
        if (!this.m_useDefault.isSelected()) {
            dataContext.put("NewObject", (Object)this.m_pickerSchema.getOrCreateDBObject());
        } else {
            dataContext.put("NewObject", null);
        }
        dataContext.put(USE_DEFAULT_KEY, (Object)this.m_useDefault.isSelected());
    }

    private void enablePicker(boolean usingDefault) {
        this.m_lblSchemaName.setEnabled(!usingDefault);
        this.m_pickerSchema.setEnabled(!usingDefault);
    }

    public static final Holder<Schema> choose(SchemaChooserContext scc) {
        boolean listenerExists;
        Namespace ns = scc.m_ns != null ? scc.m_ns : new Namespace();
        ns.put(Context.class.getName(), (Object)scc.m_context);
        ns.put("oracle.javatools.db.DBObjectProvider", (Object)scc.m_provider);
        ns.put("NewObject", (Object)scc.m_current);
        ns.put(USE_DEFAULT_KEY, (Object)(scc.m_current == null ? 1 : 0));
        SelectSchemaPanel panel = new SelectSchemaPanel();
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), scc.m_title, (Traversable)panel, ns);
        launcher.setInitialSize(320, 200);
        JEWTDialog dialog = launcher.initDialog();
        if (ModelUtil.hasLength((String)scc.m_headerText)) {
            DBDialogHeader header = new DBDialogHeader();
            header.setHeaderDescription(scc.m_headerText);
            dialog.setDialogHeader((Component)((Object)header));
        }
        dialog.setName("SchemaChooser");
        boolean bl = listenerExists = scc.m_listener != null;
        if (listenerExists) {
            dialog.addVetoableChangeListener(scc.m_listener);
        }
        panel.m_pickerSchema.setEditable(listenerExists);
        return launcher.showDialog() ? new Holder((Object)((Schema)ns.find("NewObject"))) : null;
    }

    public static final class SchemaChooserContext {
        private Context m_context;
        private DBObjectProvider m_provider;
        private Schema m_current;
        private String m_title = UIBundle.get("CHOOSE_SCHEMA_TITLE");
        private String m_headerText = UIBundle.get("CHOOSE_SCHEMA_HEADER");
        private Namespace m_ns;
        private VetoableChangeListener m_listener;

        public final void setContext(Context context) {
            this.m_context = context;
        }

        public final void setProvider(DBObjectProvider provider) {
            this.m_provider = provider;
        }

        public final void setCurrent(Schema current) {
            this.m_current = current;
        }

        public final void setTitle(String title) {
            if (ModelUtil.hasLength((String)title)) {
                this.m_title = title;
            }
        }

        public final void setHeaderText(String headerText) {
            this.m_headerText = headerText;
        }

        public final void setNamespace(Namespace ns) {
            this.m_ns = ns;
        }

        public final void setListener(VetoableChangeListener listener) {
            this.m_listener = listener;
        }
    }

    private final class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean usingDefault = SelectSchemaPanel.this.m_useDefault.isSelected();
            SelectSchemaPanel.this.enablePicker(usingDefault);
            if (usingDefault) {
                SelectSchemaPanel.this.m_previous = SelectSchemaPanel.this.m_pickerSchema.getDBObjectID();
                boolean set = false;
                if (SelectSchemaPanel.this.m_prov != null) {
                    try {
                        SelectSchemaPanel.this.m_pickerSchema.setDBObject((DBObject)SelectSchemaPanel.this.m_prov.getDefaultSchema());
                        set = true;
                    }
                    catch (DBException dbe) {
                        dbe.printStackTrace();
                    }
                }
                if (!set) {
                    SelectSchemaPanel.this.m_pickerSchema.setDBObject(null);
                }
            } else if (SelectSchemaPanel.this.m_previous != null) {
                SelectSchemaPanel.this.m_pickerSchema.setDBObjectID(SelectSchemaPanel.this.m_previous);
            }
        }
    }
}

