/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.controls.DBObjectTypePicker;
import oracle.ide.db.controls.NameFilterField;
import oracle.ide.db.controls.SchemaObjectTargetPicker;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.NameController;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.ModelUtil;

public class SelectDBObjectsPanel
extends SkippingTraversable
implements ShuttleListener {
    private static final Collection<String> OBJECT_TYPES_TO_IGNORE = Arrays.asList("SCHEMA", "RECYCLEBIN");
    public static final String SELECTED_OBJECTS = "SelectDBObjectsPanel.SELECTED_OBJECTS";
    public static final String SETTINGS_KEY = SelectDBObjectsPanel.class.getName();
    private static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    private static final String SETTINGS_QUERY_KEY = "query";
    private static final String SETTINGS_FILTER_KEY = "filter";
    private static final String SETTINGS_SCHEMA_KEY = "schema";
    private static final String SETTINGS_CONNECTION_KEY = "connection";
    private WizardCallbacks m_callBacks;
    private boolean m_entered;
    private boolean m_init;
    private boolean m_incDBLinks = true;
    private Schema m_publicSchema;
    private DBObjectProvider m_pro;
    private SchemaObjectTargetPicker m_chosen;
    private DBObjectSourcePicker m_from;
    private Collection<String> m_selectedTypes;
    private Timer m_timer;
    private final Listener m_listener = new Listener();
    private final JPanel m_centerPanel = new JPanel();
    private final JLabel m_filterLabel = new JLabel();
    private final NameFilterField m_filter = new NameFilterField();
    private final JCheckBox m_autoQuery = new JCheckBox();
    private final JLabel m_schemasLabel = new JLabel();
    private final DBObjectChooser m_schemas = new DBObjectChooser("SCHEMA");
    private final JButton m_query = new JButton();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper(this.getPanelName());
    private final Shuttle m_shuttle = new Shuttle();
    private final JLabel m_typeLabel = new JLabel();
    private final JButton m_typeButton = new JButton();
    private final DBObjectTypePicker m_typePicker = new DBObjectTypePicker();

    public SelectDBObjectsPanel() {
        try {
            this.layoutComponents();
            this.addListeners();
        }
        catch (Exception e) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Layout failed", e);
        }
    }

    protected String getPanelName() {
        return "SelectDBObjectsPanel";
    }

    protected void layoutComponents() {
        this.m_centerPanel.setLayout(new GridBagLayout());
        JPanel row1 = this.getRow1();
        this.m_centerPanel.add((Component)row1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel row2 = this.getRow2();
        this.m_centerPanel.add((Component)row2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_reshelp.setName((Component)this.m_shuttle, "Shuttle");
        this.m_centerPanel.add((Component)this.m_shuttle, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.m_centerPanel, "Center");
    }

    private JPanel getRow1() {
        JPanel row1 = new JPanel();
        row1.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_schemasLabel, this.m_schemas, UIBundle.get("PICKER_SCHEMA"), "Schema");
        row1.add((Component)this.m_schemasLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        row1.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        row1.add((Component)this.m_typeLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_typeButton, UIBundle.get("PICKER_FILTER_TYPES"), "FilterTypes");
        row1.add((Component)this.m_typeButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row1;
    }

    private JPanel getRow2() {
        JPanel row2 = new JPanel();
        row2.setLayout(new GridBagLayout());
        this.m_reshelp.resLabel(this.m_filterLabel, this.m_filter, UIBundle.get("PICKER_FILTER"), "Filter");
        row2.add((Component)this.m_filterLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_filter.setText("%");
        row2.add((Component)this.m_filter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_autoQuery, UIBundle.get("PICKER_AUTO_QUERY"), "AutoQuery");
        row2.add((Component)this.m_autoQuery, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        this.m_reshelp.resButton(this.m_query, UIBundle.get("PICKER_QUERY"), "Query");
        row2.add((Component)this.m_query, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return row2;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected NameController getNameController() {
        return null;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new DBObjectSourcePicker(this.m_pro, false, true);
        }
        return this.m_from;
    }

    protected ItemPicker getToPicker() {
        if (this.m_chosen == null) {
            NameController nameController = this.getNameController();
            this.m_chosen = new SchemaObjectTargetPicker(nameController);
            if (nameController != null) {
                this.m_shuttle.addShuttleListener((ShuttleListener)this.m_chosen);
            }
        }
        return this.m_chosen;
    }

    protected boolean canFinish() {
        return false;
    }

    protected boolean canAlwaysNext() {
        return false;
    }

    @Deprecated
    protected boolean canRenameObjects() {
        return false;
    }

    protected String[] getAvailableTypes() {
        ItemPicker to = this.getToPicker();
        if (to instanceof SchemaObjectTargetPicker) {
            DBObjectProvider source = this.m_pro;
            DBObjectProvider target = ((SchemaObjectTargetPicker)to).getProvider();
            if (source != null) {
                Collection<String> retval;
                Collection<String> types = this.getSelectableObjectTypes(source);
                if (target == null) {
                    retval = types;
                } else {
                    retval = new ArrayList<String>();
                    Collection<String> targTypes = this.getSelectableObjectTypes(target);
                    for (String type : types) {
                        if (!targTypes.contains(type)) continue;
                        retval.add(type);
                    }
                }
                return retval.toArray(new String[retval.size()]);
            }
        }
        return new String[]{"TABLE", "VIEW"};
    }

    protected Collection<String> getSelectableObjectTypes(DBObjectProvider pro) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String type : pro.listObjectTypes()) {
            if (OBJECT_TYPES_TO_IGNORE.contains(type)) continue;
            retval.add(type);
        }
        return retval;
    }

    protected String getProviderKey() {
        return "oracle.javatools.db.DBObjectProvider";
    }

    @Override
    public final void onEntry(TraversableContext dataContext) {
        super.onEntry(dataContext);
        this.m_callBacks = dataContext.getWizardCallbacks();
        if (this.isSkipping()) {
            return;
        }
        boolean providerChanged = false;
        DBObjectProvider pro = this.getProvider(dataContext);
        if (this.m_pro != pro) {
            providerChanged = true;
        }
        this.m_pro = pro;
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onEntry(dataContext);
            }
            this.init(providerChanged, dataContext);
            this.entered();
        }
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        if (this.m_pro != null) {
            ItemPicker to = this.getToPicker();
            if (to instanceof Traversable) {
                ((Traversable)to).onExit(dataContext);
            }
            this.exited();
            this.commit(dataContext);
            this.saveSettings();
        }
    }

    private void entered() {
        this.m_entered = true;
    }

    private void exited() {
        this.m_entered = false;
        this.saveSettings();
    }

    protected DBObjectProvider getProvider(TraversableContext dataContext) {
        return (DBObjectProvider)dataContext.get(this.getProviderKey());
    }

    protected void commit(TraversableContext dataContext) throws TraversalException {
        dataContext.put(SELECTED_OBJECTS, this.getSelectedObjects());
    }

    protected Object getSelectedObjects() {
        Object[] retval = null;
        ItemPicker to = this.getToPicker();
        if (to instanceof SchemaObjectTargetPicker) {
            ListModel model = ((SchemaObjectTargetPicker)to).getList().getModel();
            int c = model.getSize();
            retval = new SchemaObjectDescriptor[c];
            for (int i = 0; i < c; ++i) {
                ((SchemaObjectDescriptor[])retval)[i] = (SchemaObjectDescriptor)model.getElementAt(i);
            }
        } else {
            retval = to.getAllSelectableItems();
        }
        return retval;
    }

    protected void setIncludePublicSchema(boolean inc) {
        this.m_publicSchema = inc ? new Schema("PUBLIC") : null;
    }

    public void setIncludeDatabaseLinks(boolean inc) {
        this.m_incDBLinks = inc;
        if (this.m_schemas != null) {
            this.m_schemas.setShowDBLinkButton(inc);
        }
    }

    protected void init(boolean providerChanged, TraversableContext dataContext) {
        boolean doQuery = providerChanged;
        if (!this.m_init) {
            this.m_init = true;
            doQuery = true;
            this.m_schemas.setShowDBLinkButton(this.m_incDBLinks);
        }
        this.m_typePicker.setAvailableTypes(this.m_pro, true, this.getAvailableTypes());
        this.m_filter.setDescriptor(this.m_pro.getDescriptor());
        this.loadSettings();
        if (doQuery) {
            Schema defaultSchema = (Schema)dataContext.get("oracle.javatools.db.Schema");
            this.getFromPicker().setProvider(this.m_pro);
            if (defaultSchema == null) {
                try {
                    defaultSchema = this.m_pro.getDefaultSchema();
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dbe.getMessage()));
                }
            }
            this.m_schemas.setProvider(this.m_pro);
            this.m_schemas.setDBObject((DBObject)defaultSchema);
            this.loadSchemaSetting();
            this.selectTypes();
        }
        this.checkWizardButtons();
        JLabel lblFrom = new JLabel();
        JLabel lblTo = new JLabel();
        DBObjectSourcePicker fromPick = this.getFromPicker();
        ItemPicker toPick = this.getToPicker();
        this.m_shuttle.setFromPicker((ItemPicker)fromPick);
        this.m_shuttle.setToPicker(toPick);
        this.m_reshelp.setName(fromPick.getComponent(), "From");
        this.m_reshelp.setName(toPick.getComponent(), "To");
        this.m_shuttle.add((Component)lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)lblTo, (Object)"ToHeader");
        fromPick.setTitleLabel(UIBundle.get("PICKER_AVAILABLE"), this.getPanelName());
        if (toPick.getComponent() instanceof ComponentWithTitlebar) {
            ComponentWithTitlebar compWithTitleBar = (ComponentWithTitlebar)toPick.getComponent();
            this.m_reshelp.resLabel(lblTo, compWithTitleBar.getComponent(), UIBundle.get("PICKER_SELECTED"), "Selected");
            compWithTitleBar.setLabel(lblTo);
        }
        if (doQuery && this.m_autoQuery.isSelected()) {
            this.fireQuery();
        }
        if (this.m_callBacks != null) {
            if (this.m_autoQuery.isSelected()) {
                if (!this.getToPicker().isSelectableItemPresent()) {
                    this.m_callBacks.wizardSetInitialFocus((Component)this.getFromPicker().getTree());
                }
            } else {
                this.m_callBacks.wizardSetInitialFocus((Component)this.m_query);
            }
        }
    }

    protected void fireQuery() {
        this.getTimer().stop();
        DBObjectSourcePicker from = this.getFromPicker();
        if (from != null && this.m_selectedTypes != null) {
            Schema schema = (Schema)this.m_schemas.getDBObject();
            String filter = this.m_filter.getFilter();
            String[] types = this.m_selectedTypes.toArray(new String[this.m_selectedTypes.size()]);
            this.setupQuery(from, schema, filter, types);
            this.getTimer().stop();
            from.query();
            this.m_shuttle.setEnabled(true);
        }
    }

    protected void setupQuery(DBObjectSourcePicker from, Schema schema, String filter, String[] types) {
        from.setSchema(schema);
        from.setTypes(types);
        from.setFilter(filter);
    }

    private void selectTypes() {
        StringBuilder typesTT = new StringBuilder();
        typesTT.append(StringUtils.stripMnemonic((String)UIBundle.get("PICKER_TYPES")));
        this.m_selectedTypes = this.m_typePicker.getSelectedTypes();
        for (String type : this.m_selectedTypes) {
            typesTT.append(" ");
            typesTT.append(DBTypeDisplayRegistry.getDisplayName(type));
        }
        DBObjectRenderer.setToolTipText(this.m_typeButton, typesTT.toString());
        if (this.m_selectedTypes.equals(this.m_typePicker.getDefaultSelection())) {
            this.m_typeLabel.setText(UIBundle.get("PICKER_TYPEFILTER_OFF"));
        } else {
            this.m_typeLabel.setText(UIBundle.get("PICKER_TYPEFILTER_ON"));
        }
    }

    private Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener alist = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            };
            this.m_timer = new Timer(2000, alist);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    protected void loadSettings() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            boolean aq = settings.getBoolean(SETTINGS_AUTO_QUERY_KEY, false);
            this.m_autoQuery.setSelected(aq);
            this.m_query.setEnabled(!aq);
            ArrayList<String> selection = new ArrayList<String>();
            Collection<String> allTypes = this.m_typePicker.getAvailableTypes();
            for (String type : allTypes) {
                if (!settings.getBoolean(SETTINGS_QUERY_KEY + type, true)) continue;
                selection.add(type);
            }
            this.m_typePicker.setSelectedTypes(selection.isEmpty() ? allTypes : selection);
            if (this.useSavedFilterAndSchema()) {
                this.m_filter.setFilter(settings.getString(SETTINGS_FILTER_KEY));
            }
        } else {
            this.setDefaultSettings();
        }
    }

    private void loadSchemaSetting() {
        HashStructure settings = this.getSettings();
        if (settings != null) {
            String schemaName;
            String connectionName = this.getConnectionName();
            if (this.useSavedFilterAndSchema() && ModelUtil.hasLength((String)(schemaName = settings.getString(SETTINGS_SCHEMA_KEY)))) {
                try {
                    Schema schema = this.m_pro.getSchema(schemaName);
                    this.m_schemas.setDBObject((DBObject)schema);
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dbe.getMessage()));
                }
            }
        }
    }

    private boolean useSavedFilterAndSchema() {
        String userName;
        String connectionName;
        HashStructure settings = this.getSettings();
        return settings != null && ModelUtil.hasLength((String)(connectionName = this.getConnectionName())) && connectionName.equals(settings.getString(SETTINGS_CONNECTION_KEY)) && ModelUtil.hasLength((String)(userName = this.getUserName())) && userName.equals(settings.getString(SETTINGS_SCHEMA_KEY));
    }

    private HashStructure getSettings() {
        String key = this.getSettingsKey();
        HashStructure settings = null;
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            settings = ps.getProperties().getHashStructure(key);
        }
        return settings;
    }

    protected void setDefaultSettings() {
        boolean autoQuery = !(this.m_pro instanceof Database);
        this.m_autoQuery.setSelected(autoQuery);
        this.m_query.setEnabled(!autoQuery);
        Collection<String> defaultTypes = DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter();
        if (defaultTypes != null) {
            this.m_typePicker.setSelectedTypes(defaultTypes);
        }
    }

    protected void saveSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            PropertyStorage ps = this.getPropertyStorage();
            HashStructure settings = ps.getProperties().getOrCreateHashStructure(key);
            settings.putBoolean(SETTINGS_AUTO_QUERY_KEY, this.m_autoQuery.isSelected());
            Collection<String> selTypes = this.m_typePicker.getSelectedTypes();
            if (selTypes.equals(this.m_typePicker.getDefaultSelection())) {
                selTypes = null;
            }
            for (String type : this.m_typePicker.getAvailableTypes()) {
                String typeKey = SETTINGS_QUERY_KEY + type;
                if (selTypes == null || selTypes.contains(type)) {
                    settings.remove(typeKey);
                    continue;
                }
                settings.putBoolean(typeKey, false);
            }
            settings.putString(SETTINGS_CONNECTION_KEY, this.getConnectionName());
            settings.putString(SETTINGS_FILTER_KEY, this.m_filter.getFilter());
            Schema schema = (Schema)this.m_schemas.getDBObject();
            if (schema != null) {
                settings.putString(SETTINGS_SCHEMA_KEY, schema.getName());
            }
        }
    }

    private String getConnectionName() {
        String connectionName = null;
        if (this.m_pro instanceof Database) {
            connectionName = ((Database)this.m_pro).getConnectionName();
        }
        return connectionName;
    }

    private String getUserName() {
        String userName = null;
        if (this.m_pro instanceof Database) {
            try {
                userName = ((Database)this.m_pro).getUserName();
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)((Object)this)).warning(UIBundle.format("PICKER_SCHEMA_LOAD_ERR", dbe.getMessage()));
            }
        }
        return userName;
    }

    protected void checkWizardButtons() {
        ItemPicker to;
        if (this.m_callBacks != null && (to = this.getToPicker()) != null) {
            Boolean finish;
            Transferable[] t = to.getAllSelectableItems();
            boolean haveStuff = t != null && t.length > 0;
            Boolean bl = finish = this.canFinish() && haveStuff ? Boolean.TRUE : Boolean.FALSE;
            Boolean next = this.canAlwaysNext() ? Boolean.TRUE : (haveStuff ? Boolean.TRUE : Boolean.FALSE);
            this.m_callBacks.wizardEnableButtons(null, next, finish);
        }
    }

    private void showFilterTypesDialog() {
        if (this.m_typePicker.showFilterTypesDialog(this.m_typeButton)) {
            this.selectTypes();
            if (this.m_autoQuery.isSelected()) {
                this.fireQuery();
            }
        }
    }

    @Override
    protected String getTraversableName() {
        return null;
    }

    public final Shuttle getShuttle() {
        return this.m_shuttle;
    }

    protected final WizardCallbacks getWizardCallbacks() {
        return this.m_callBacks;
    }

    public void shuttleItemsMoved(ShuttleEvent event) {
        this.checkWizardButtons();
    }

    public void shuttleItemsRemoved(ShuttleEvent event) {
        this.checkWizardButtons();
    }

    public void shuttleItemsReordered(ShuttleEvent event) {
    }

    private void addListeners() {
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.m_schemas.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                    SelectDBObjectsPanel.this.fireQuery();
                }
            }
        });
        this.m_typeButton.addActionListener(this.m_listener);
        this.m_filter.getDocument().addDocumentListener(this.m_listener);
        this.m_filter.addKeyListener(this.m_listener);
        this.m_autoQuery.addItemListener(this.m_listener);
        this.m_query.addActionListener(this.m_listener);
    }

    private class Listener
    implements ActionListener,
    ItemListener,
    DocumentListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectDBObjectsPanel.this.m_entered) {
                Object source = e.getSource();
                if (source == SelectDBObjectsPanel.this.m_query) {
                    SelectDBObjectsPanel.this.fireQuery();
                } else if (source == SelectDBObjectsPanel.this.m_typeButton) {
                    SelectDBObjectsPanel.this.showFilterTypesDialog();
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source;
            if (SelectDBObjectsPanel.this.m_entered && (source = e.getSource()) == SelectDBObjectsPanel.this.m_autoQuery) {
                switch (e.getStateChange()) {
                    case 1: {
                        SelectDBObjectsPanel.this.m_query.setEnabled(false);
                        SelectDBObjectsPanel.this.getTimer().restart();
                        break;
                    }
                    case 2: {
                        SelectDBObjectsPanel.this.m_query.setEnabled(true);
                    }
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (SelectDBObjectsPanel.this.m_entered && SelectDBObjectsPanel.this.m_autoQuery.isSelected()) {
                SelectDBObjectsPanel.this.getTimer().restart();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SelectDBObjectsPanel.this.fireQuery();
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

