/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DefaultPropertyValueFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UnsupportedPropertyFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

public class DDLPanel
extends DefaultTraversablePanel
implements ActionListener {
    @Deprecated
    public static final String DDL_GENERATOR = "DDlGenerator";
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIBundle.get("SQL_URLFILTER_TEXT"), ".sql");
    private JButton m_btnSave;
    private final BasicEditorPane m_txtSQL = new BasicEditorPane();
    private boolean m_showRadio;
    private ButtonGroup m_btnGrp;
    private JRadioButton m_rdbCreate;
    private JRadioButton m_rdbUpdate;
    private DBEditorConfig m_config;
    private SystemObject m_originalObjectForDDL;
    private final DBObjectListener m_list = new SwingDBObjectListener(){

        @Override
        public void updateUI(DBObjectChange change) {
            DDLPanel.this.updateSQL();
        }
    };

    public DDLPanel() {
        this(true);
    }

    public DDLPanel(boolean chooseCreateUpdate) {
        this.m_showRadio = chooseCreateUpdate;
        this.setHelpID("f1_odbddl_html");
    }

    protected final DBEditorConfig getEditorConfig() {
        return this.m_config;
    }

    public void onEntry(TraversableContext data) {
        this.m_config = (DBEditorConfig)data.find(DBEditorConfig.class);
        this.layoutComponents();
        if (this.m_rdbUpdate != null) {
            this.m_originalObjectForDDL = this.getOriginalObjectForDDL();
            if (this.m_originalObjectForDDL == null) {
                this.m_rdbUpdate.setEnabled(false);
                this.m_rdbCreate.setSelected(true);
            } else {
                this.m_rdbUpdate.setEnabled(true);
                if (this.defaultToAlterWhenEditing()) {
                    this.m_rdbUpdate.setSelected(true);
                } else {
                    this.m_rdbCreate.setSelected(true);
                }
            }
        }
        if (this.m_config != null) {
            SystemObject obj = this.m_config.getUpdatedObject();
            obj.addObjectListener(this.m_list);
        }
        this.updateSQL();
    }

    private void updateSQL() {
        String txt;
        boolean isError = false;
        try {
            txt = this.getSQL();
        }
        catch (UnsupportedDDLException ude) {
            isError = true;
            txt = ude.getMessage();
        }
        catch (Exception e) {
            txt = UIBundle.get("DDL_ERROR");
            DBLog.logStackTrace((String)txt, (Throwable)e);
            isError = true;
        }
        TextBuffer buff = TextBufferFactory.createArrayTextBuffer();
        if (txt != null) {
            buff.insert(0, txt.toCharArray());
        }
        BasicDocument doc = new BasicDocument(buff);
        doc.setLanguageSupport(isError ? "foo.txt" : "foo.sql");
        this.m_txtSQL.setDocument((Document)doc);
        this.m_btnSave.setEnabled(ModelUtil.hasLength((String)txt) && !isError);
    }

    public void onExit(TraversableContext data) throws TraversalException {
        if (this.m_config != null) {
            SystemObject obj = this.m_config.getUpdatedObject();
            obj.removeObjectListener(this.m_list);
        }
    }

    protected SystemObject getOriginalObjectForDDL() {
        SystemObject retval = this.getEditorConfig().getOriginalObject();
        if (retval != null && retval.getID() == null) {
            retval = null;
        }
        return retval;
    }

    protected boolean defaultToAlterWhenEditing() {
        return true;
    }

    protected boolean useProviderTransactionForDiff() {
        return this.m_config != null && this.m_config.isCommitToProvider();
    }

    protected String getSQL() throws UnsupportedDDLException {
        SystemObject origObjForTxn;
        DBObjectProvider pro = this.m_config.getProvider();
        SystemObject upd = this.m_config.getUpdatedObject();
        boolean replace = this.m_config.isReplaceAllowed();
        DDLOptions options = new DDLOptions(replace, false);
        DDLGenerator gen = DDLPanel.getDDLGenerator(this.m_config);
        if (gen == null) {
            DBLog.getLogger((Object)this).warning("No DDL generator found. DDL panel will not function.");
            return null;
        }
        Object object = origObjForTxn = this.m_rdbCreate != null && this.m_rdbCreate.isSelected() ? null : this.m_originalObjectForDDL;
        if (origObjForTxn == null) {
            options.setReplace(false);
        }
        Difference diff = null;
        if (this.useProviderTransactionForDiff()) {
            DBObjectTransaction txn = new DBObjectTransaction(pro);
            txn.includeUpdate(origObjForTxn, (SystemObject)DBUtil.makeClonedCopy((DBObject)upd));
            txn.setReplace(true);
            txn.setCascade(true);
            try {
                Difference txnDiff = txn.getTransactionDifference();
                diff = txnDiff.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(pro)});
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (diff == null) {
            diff = pro.getDiffEngine().difference((Object)origObjForTxn, (Object)upd);
            diff = diff.getFilteredDifference(new DifferenceFilter[]{new UnsupportedPropertyFilter(pro, gen), new DefaultPropertyValueFilter(pro.getPropertyManager(), (PropertyManager)gen)});
        }
        DDL ddl = gen.getUpdateDDL(options, diff);
        return ddl.toString();
    }

    private void layoutComponents() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper reshelp = new DBUIResourceHelper("DDLPanel");
            boolean flat = this.m_config != null && this.m_config.isInFlatEditor();
            DBUILayoutHelper layout = new DBUILayoutHelper((JPanel)((Object)this), flat);
            JLabel lblSQL = new JLabel();
            reshelp.resLabel(lblSQL, (Component)this.m_txtSQL, UIBundle.get("DDL_LABEL_SQL"), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            reshelp.resButton(this.m_btnSave, UIBundle.get("DDL_BUTTON_SAVE"), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane scrSQL = new JScrollPane((Component)this.m_txtSQL);
            layout.add(lblSQL);
            layout.nextRow();
            if (this.m_showRadio) {
                this.m_rdbCreate = new JRadioButton();
                this.m_rdbCreate.addActionListener(this);
                reshelp.resButton(this.m_rdbCreate, UIBundle.get("DDL_CREATE"), "Create");
                this.m_rdbUpdate = new JRadioButton();
                this.m_rdbUpdate.addActionListener(this);
                reshelp.resButton(this.m_rdbUpdate, UIBundle.get("DDL_UPDATE"), "Update");
                this.m_btnGrp = new ButtonGroup();
                this.m_btnGrp.add(this.m_rdbCreate);
                this.m_btnGrp.add(this.m_rdbUpdate);
                layout.add(this.m_rdbCreate);
                layout.add(this.m_rdbUpdate);
                layout.nextRow();
            }
            layout.add(scrSQL, 3, 1);
            layout.add(Box.createVerticalStrut(200), 1, 1, false, false);
            layout.nextRow();
            layout.nextColumn();
            layout.nextColumn();
            layout.add(this.m_btnSave);
            layout.getConstraints((Component)this.m_btnSave).anchor = 13;
            layout.layout();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.m_btnSave) {
            URLChooser chooser = DialogUtil.newURLChooser();
            chooser.clearChooseableURLFilters();
            chooser.setURLFilter(SQL_FILTER);
            URL url = null;
            while (chooser.showSaveDialog((Component)((Object)this)) == 0) {
                url = chooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)url))) {
                    String path = URLFileSystem.getPath((URL)url);
                    url = URLFactory.replacePathPart((URL)url, (String)(path + EXT));
                }
                try {
                    url = NewFilePanel.validateURL((Component)((Object)this), (URL)url, (String)UIBundle.get("SQLFILE_TYPE"), (boolean)true);
                }
                catch (TraversalException ex) {
                    ex.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (url == null) continue;
            }
            if (url != null) {
                try {
                    OutputStream os = URLFileSystem.openOutputStream((URL)url);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, IdeUtil.getIdeEncoding()));
                    writer.write(this.m_txtSQL.getText());
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException ex) {
                    DBMessageDialog.showErrorDialog(ex, this, Level.SEVERE, null, UIBundle.get("DDL_ERROR_SAVE_TITLE"), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public static DDLGenerator getDDLGenerator(DBEditorConfig config) {
        DDLGenerator gen = null;
        DBObjectProvider pro = config.getProvider();
        if (pro != null) {
            gen = pro.getDescriptor().getDDLGenerator(pro);
        }
        return gen;
    }
}

