/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.model;

import java.util.List;
import java.util.logging.Logger;
import oracle.ide.db.insight.model.DBInsightProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;

public class ParentLocator {
    private DBInsightProvider m_DBInsightProvider = null;

    protected final void setDBInsightProvider(DBInsightProvider insightProvider) {
        this.m_DBInsightProvider = insightProvider;
    }

    protected final DBObject getContextObjectAtOffset() {
        return this.m_DBInsightProvider.getContextObjectAtOffset();
    }

    protected final DBObjectProvider getProvider() {
        return this.m_DBInsightProvider.getProvider();
    }

    protected final String getText() {
        return this.m_DBInsightProvider.getText();
    }

    protected final int getOffset() {
        return this.m_DBInsightProvider.getOffset();
    }

    protected final String getSearchString() {
        return this.m_DBInsightProvider.getMatchingText();
    }

    protected final Schema getSchema() {
        return this.m_DBInsightProvider.getSchema();
    }

    protected DBObject getParent(List<String> names) throws CancelledException {
        return DBInsightProvider.resolveIDForInsight(this.createID(names));
    }

    private DBObjectID createID(List<String> names) {
        ReferenceID retval = null;
        int size = names.size();
        String schemaName = this.getSchema().getName();
        for (int i = 0; i < size; ++i) {
            String name = names.get(i);
            if (i < size - 1 && names.get(i + 1).startsWith("(")) {
                name = name + names.get(++i);
            }
            ReferenceID id = new ReferenceID("UNSPECIFIED_TYPE", schemaName, name);
            id.setParent(retval);
            id.setProvider(this.getProvider());
            schemaName = null;
            retval = id;
        }
        return retval;
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }
}

