/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.insight.completion;

import java.awt.Component;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.accessibility.AccessibleContext;
import javax.swing.JList;
import oracle.ide.db.insight.model.DBInsightData;
import oracle.ide.insight.completion.ui.InsightCellRenderer;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;

class DBInsightCellRenderer
extends InsightCellRenderer<DBInsightData> {
    public DBInsightCellRenderer(InsightViewCustomizer insightViewCustomizer) {
        super(insightViewCustomizer);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DBInsightData item = (DBInsightData)value;
        this.setIconTextGap(4);
        AccessibleContext ac = this.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(item.getAccessibleText());
        }
        this.setIcon(item.getIcon());
        AttributedString aText = new AttributedString(item.getName());
        if (aText.getIterator().getEndIndex() > 0) {
            aText.addAttribute(TextAttribute.FAMILY, list.getFont().getFamily());
        }
        this.setAttributedText(aText);
        AttributedString aDesc = new AttributedString(item.getDescription());
        if (aDesc.getIterator().getEndIndex() > 0) {
            aDesc.addAttribute(TextAttribute.FAMILY, list.getFont().getFamily());
            aDesc.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
        }
        this.setDescription(aDesc);
        return super.getListCellRendererComponent(list, (Object)item, index, isSelected, cellHasFocus);
    }
}

