/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.util.logging.Level;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

public class DBEditorFactoryRegistry {
    private DBEditorFactoryRegistry() {
    }

    public static DBEditorFactory findFactory(DBObjectProvider pro) {
        DatabaseUIExtensionHook hook;
        DBEditorFactory retval = null;
        if (pro != null && (hook = DatabaseUIExtensionHook.getHook()) != null) {
            retval = hook.findEditorFactory(pro);
        }
        return retval;
    }

    public static DBEditorFactory findDatabaseFactory(DatabaseDescriptor desc) {
        DBEditorFactory retval = null;
        DatabaseUIExtensionHook hook = DatabaseUIExtensionHook.getHook();
        if (hook != null) {
            retval = hook.findDatabaseEditorFactory(desc);
        }
        return retval;
    }

    @Deprecated
    public static DBEditorFactory findFactory(Class<? extends DBObjectProvider> c) {
        DatabaseDescriptor desc;
        DBEditorFactory retval = null;
        DatabaseUIExtensionHook hook = DatabaseUIExtensionHook.getHook();
        if (hook != null) {
            retval = hook.findEditorFactory(c);
        }
        if (retval == null && Database.class.isAssignableFrom(c) && (desc = DatabaseFactory.getDatabaseDescriptor(c)) != null) {
            retval = DBEditorFactoryRegistry.findDatabaseFactory(desc);
        }
        return retval;
    }

    @Deprecated
    public static void registerDBEditorFactory(Class providerClass, DBEditorFactory factory) {
    }

    public static DBEditorFactory getCreateFactory(DBEditorConfig config) {
        return DBEditorFactoryRegistry.getCreateFactory(config.getProvider(), config.getObjectType());
    }

    public static DBEditorFactory getCreateFactory(DBObjectProvider pro, String dbObjectType) {
        DBEditorFactory retval = null;
        DBEditorFactory f = DBEditorFactoryRegistry.findFactory(pro);
        if (f != null && f.canCreateDBObject(null, pro, dbObjectType)) {
            retval = f;
        }
        return retval;
    }

    public static DBEditorFactory getCreateFactory(DBObjectTypeNode node) {
        String type;
        DBEditorFactory retval = null;
        if (node != null && (type = DBObjectNodeUtil.normalizeType(node)) != null) {
            Object proID = node.getProviderIdentifier();
            String proType = node.getProviderType();
            if (proID != null && proType != null) {
                try {
                    retval = DBEditorFactoryRegistry.getCreateFactory(DBObjectProviderFactory.findOrCreateProvider((String)proType, (Object)proID), type);
                }
                catch (DBException dbe) {
                    DBLog.getLogger(DBEditorFactoryRegistry.class).log(Level.FINE, "Couldn't get provider: " + dbe.getMessage());
                }
            }
        }
        return retval;
    }

    public static DBEditorFactory getEditFactory(DBEditorConfig config) {
        Object retval = null;
        Object obj = config.isChildEditOnly() ? config.getChildObject() : config.getOriginalObject();
        return DBEditorFactoryRegistry.getEditFactory(obj, config.getProvider());
    }

    public static DBEditorFactory getEditFactory(SchemaObject obj, DBObjectProvider pro) {
        return DBEditorFactoryRegistry.getEditFactory((DBObject)obj, pro);
    }

    public static DBEditorFactory getEditFactory(DBObject obj, DBObjectProvider pro) {
        DBEditorFactory retval = null;
        DBEditorFactory f = DBEditorFactoryRegistry.findFactory(pro);
        if (f != null && f.canEditDBObject(obj, pro)) {
            retval = f;
        }
        return retval;
    }

    public static DBEditorFactory getEditFactory(DBObjectNode node) {
        Class clz;
        DBObjectProvider pro;
        DBEditorFactory retval = null;
        String type = DBObjectNodeUtil.normalizeType(node);
        if (type != null && (pro = node.getProvider()) != null && (clz = Metadata.getInstance().getObjectClass(type)) != null) {
            DBObject obj = null;
            if (AbstractBuildableObject.class.isAssignableFrom(clz) && SystemObject.class.isAssignableFrom(clz)) {
                try {
                    obj = (DBObject)clz.newInstance();
                    obj.setName(node.getObjectName());
                    if (obj instanceof SchemaObject) {
                        ((SchemaObject)obj).setSchema(new Schema(node.getSchemaName()));
                    }
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (obj == null) {
                obj = node.getDBObject();
            }
            retval = DBEditorFactoryRegistry.getEditFactory(obj, pro);
        }
        return retval;
    }
}

