/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

abstract class AbstractDBEditorFactory
implements DBEditorFactory {
    AbstractDBEditorFactory() {
    }

    @Override
    public final boolean canCreateDBObject(DBObjectTypeNode node) {
        boolean retval = false;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((String)node.getProviderType(), (Object)node.getProviderIdentifier());
            if (pro != null) {
                Schema schema = DBObjectNodeUtil.getSchema(node, false);
                retval = this.canCreateDBObject(schema, pro, DBObjectNodeUtil.normalizeType(node));
            }
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, dbe);
        }
        return retval;
    }

    @Override
    @Deprecated
    public final SchemaObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType) {
        if (!Metadata.getInstance().isSchemaObject(dbObjectType)) {
            throw new IllegalArgumentException(dbObjectType + " is not a valid SchemaObject type");
        }
        return (SchemaObject)this.createDBObject(schema, pro, dbObjectType, null, true);
    }

    @Override
    @Deprecated
    public final SchemaObject createDBObject(DBObjectTypeNode node) {
        SchemaObject obj = null;
        try {
            DBObjectProvider pro = DBObjectProviderFactory.findOrCreateProvider((String)node.getProviderType(), (Object)node.getProviderIdentifier());
            Schema schema = DBObjectNodeUtil.getSchema(node, true);
            obj = this.createDBObject(schema, pro, DBObjectNodeUtil.normalizeType(node));
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, dbe);
        }
        return obj;
    }

    @Override
    @Deprecated
    public final <T extends SystemObject> T createDBObject(Schema schema, DBObjectProvider pro, T template, boolean commitToProvider) {
        return this.createDBObject(schema, pro, template, (DBObject)null, commitToProvider);
    }

    @Override
    @Deprecated
    public final <T extends DBObject> T createDBObject(DBObjectProvider pro, T template, DBObject parent, boolean commitToProvider) {
        return this.createDBObject(DBUtil.getSchema((DBObject)parent), pro, template, parent, commitToProvider);
    }

    @Deprecated
    protected final <T extends DBObject> T createDBObject(Schema schema, DBObjectProvider pro, T template, DBObject parent, boolean commitToProvider) {
        DBObject obj = pro.getObjectFactory().newObject(template, parent);
        DBEditorConfig config = DBEditorConfig.newCreateConfig(pro, obj);
        config.setSchema(schema);
        config.setCommitToProvider(commitToProvider);
        config.setUseBackgroundTask(false);
        this.launchDialog(config);
        return (T)(config.getResult() == DBEditorConfig.Result.SUCCESS ? config.getUpdatedObject() : null);
    }

    @Override
    @Deprecated
    public final DBObject createDBObject(DBObjectNode node, String dbObjectType) {
        DBObjectProvider pro = node.getProvider();
        DBObject parent = node.getDBObject();
        Schema schema = DBObjectNodeUtil.getSchema(node, true);
        return this.createDBObject(schema, pro, dbObjectType, parent, true);
    }

    @Override
    @Deprecated
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro) {
        return this.createDBObject(newObj, pro, true);
    }

    @Override
    @Deprecated
    public final boolean createDBObject(DBObject newObj, DBObjectProvider pro, boolean commitToProvider) {
        DBEditorConfig config = DBEditorConfig.newCreateConfig(pro, newObj);
        config.setCommitToProvider(commitToProvider);
        config.setUseBackgroundTask(false);
        this.launchDialog(config);
        return true;
    }

    @Override
    @Deprecated
    public final DBObject createDBObject(Schema schema, DBObjectProvider pro, String dbObjectType, DBObject parent, boolean commitToProvider) {
        DBEditorConfig config;
        if (parent == null) {
            config = DBEditorConfig.newCreateConfig(pro, dbObjectType, schema);
        } else {
            config = DBEditorConfig.newCreateConfig(pro, dbObjectType, parent);
            config.setSchema(schema);
        }
        config.setCommitToProvider(commitToProvider);
        config.setUseBackgroundTask(false);
        this.launchDialog(config);
        return config.getUpdatedObject();
    }

    @Override
    public final boolean canEditDBObject(SchemaObject obj, DBObjectProvider pro) {
        return this.canEditDBObject((DBObject)obj, pro);
    }

    @Override
    @Deprecated
    public final boolean canEditDBObject(DBObjectNode node) {
        return this.canEditDBObject(node.getDBObject(), node.getProvider());
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro) {
        return this.editDBObject(obj, pro, true);
    }

    @Override
    @Deprecated
    public final boolean editDBObject(SchemaObject obj, DBObjectProvider pro) {
        return this.editDBObject((DBObject)obj, pro, true);
    }

    @Override
    @Deprecated
    public boolean editDBObject(DBObject obj, DBObjectProvider pro, boolean commitToProvider) {
        return this.editDBObject(obj, pro, null, commitToProvider);
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child) {
        return this.editDBObject(obj, pro, child, true);
    }

    @Override
    public final boolean editDBObject(DBObjectNode node) {
        DBEditorConfig config = DBEditorConfig.newEditConfig(node);
        this.launchDialog(config);
        return config.getResult() == DBEditorConfig.Result.SUCCESS;
    }

    @Override
    @Deprecated
    public final boolean editDBObject(DBObject obj, DBObjectProvider pro, DBObject child, boolean commitToProvider) {
        DBEditorConfig config = DBEditorConfig.newEditConfig(pro, obj);
        if (child != null) {
            config.setChildObject(child);
        }
        config.setCommitToProvider(commitToProvider);
        config.setUseBackgroundTask(false);
        this.launchDialog(config);
        return config.getResult() == DBEditorConfig.Result.SUCCESS;
    }
}

