/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.event.DBObjectPropertyListener;
import oracle.javatools.db.validators.ValidationException;

public class NameTextField
extends JTextField {
    private boolean m_listening;
    private Timer m_timer;
    private LiveValidationController m_vController;
    private String m_originalName;
    private String m_currentName;
    private Schema m_originalSchema;
    private Schema m_currentSchema;
    private DBObject m_dbObject;
    private DBObjectProvider m_pro;
    private String m_errorMessage;
    private DBObjectListener m_objListener = new DBObjectPropertyListener(new String[]{"schema"}){

        protected void propertyChanged(DBObject obj, String propertyName, PropertyChangeEvent pce) {
            NameTextField.this.commitName();
        }
    };

    public NameTextField() {
        this(true);
    }

    public NameTextField(boolean popupValidation) {
        this.setColumns(30);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NameTextField.this.commitName();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NameTextField.this.showNameError(NameTextField.this.commitIdentifier(true));
            }
        });
        if (popupValidation) {
            this.m_vController = new LiveValidationController(this);
        }
    }

    public void commitName() {
        if (this.m_listening) {
            if (this.m_errorMessage != null) {
                this.showNameError(this.commitIdentifier());
            }
            this.getTimer().restart();
        }
    }

    public void init(DBObject obj, DBObjectProvider pro) {
        this.init(obj, null, pro);
    }

    public void init(DBObject obj, DBObject originalObj, DBObjectProvider pro) {
        if (originalObj != null) {
            this.m_originalName = originalObj.getName();
            this.m_originalSchema = originalObj instanceof SchemaObject ? ((SchemaObject)originalObj).getSchema() : null;
        } else if (obj != null) {
            this.m_originalName = obj.getName();
            this.m_originalSchema = obj instanceof SchemaObject ? ((SchemaObject)obj).getSchema() : null;
        } else {
            this.m_originalName = null;
            this.m_originalSchema = null;
        }
        this.setCurrentNameAndSchema(this.m_originalName, this.m_originalSchema);
        this.m_pro = pro;
        if (this.m_dbObject != obj) {
            this.removeObjectListener();
            this.m_dbObject = obj;
            if (obj instanceof SchemaObject) {
                obj.addObjectListener(this.m_objListener);
            }
        }
        if (obj != null) {
            this.setText(pro.getExternalName(obj.getName(), obj.getType()));
            this.m_listening = true;
        } else {
            this.setText(null);
            this.m_listening = false;
        }
    }

    public void commit() throws TraversalException {
        this.m_listening = true;
        this.m_errorMessage = this.commitIdentifier();
        if (this.m_errorMessage != null) {
            throw new TraversalException(this.m_errorMessage);
        }
        this.m_listening = false;
        this.removeObjectListener();
    }

    private void removeObjectListener() {
        if (this.m_dbObject instanceof SchemaObject) {
            this.m_dbObject.removeObjectListener(this.m_objListener);
        }
    }

    public void initialiseObjectListener() {
        this.removeObjectListener();
        if (this.m_dbObject instanceof SchemaObject) {
            this.m_dbObject.addObjectListener(this.m_objListener);
        }
    }

    protected Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener alist = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NameTextField.this.showNameError(NameTextField.this.commitIdentifier());
                }
            };
            this.m_timer = new Timer(1500, alist);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    private String commitIdentifier() {
        return this.commitIdentifier(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String commitIdentifier(boolean updateText) {
        this.getTimer().stop();
        if (this.m_dbObject != null && this.m_listening) {
            String type = this.m_dbObject.getType();
            String textValue = this.getText();
            String name = this.m_pro.getInternalName(textValue, type);
            boolean doValidation = this.hasNameChanged(name);
            if (doValidation) {
                try {
                    this.m_pro.validateName(type, textValue);
                    this.m_dbObject.setName(name);
                }
                catch (ValidationException ve) {
                    String string = ve.getLocalizedMessage();
                    return string;
                }
                finally {
                    this.m_currentName = name;
                }
            }
            if (updateText && this.m_errorMessage == null) {
                this.m_listening = false;
                this.setText(this.m_pro.getExternalName(name, this.m_dbObject.getType()));
                this.m_listening = true;
            }
            if (this.m_dbObject instanceof SystemObject) {
                String unique;
                Schema schema;
                if (!doValidation && this.m_dbObject instanceof SchemaObject && (schema = ((SchemaObject)this.m_dbObject).getSchema()) != null) {
                    if (this.hasSchemaChanged(schema)) {
                        this.m_currentSchema = schema;
                        doValidation = true;
                    } else {
                        return this.m_errorMessage;
                    }
                }
                boolean sameAsOriginal = this.isSameAsOriginal(this.m_dbObject);
                if (doValidation && !sameAsOriginal && !name.equals(unique = this.m_pro.getUniqueName(type, (DBObject)DBUtil.getSchema((DBObject)this.m_dbObject), name))) {
                    return UIBundle.get("DBOBJECT_CREATE_OBJ_EXISTS");
                }
            }
        }
        return null;
    }

    protected void showNameError(String error) {
        if (this.m_vController != null) {
            this.m_errorMessage = error;
            this.m_vController.showError(error);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.m_vController != null) {
            this.m_vController.hidePopup();
        }
        super.setEnabled(enabled);
    }

    private void setCurrentNameAndSchema(String name, Schema schema) {
        this.m_currentName = name;
        this.m_currentSchema = schema;
    }

    private boolean hasNameChanged(String newName) {
        String objType = this.m_dbObject.getType();
        boolean retval = this.m_currentName == null || !this.m_pro.getDescriptor().areNamesEqual(newName, this.m_currentName, objType, false);
        return retval;
    }

    private boolean hasSchemaChanged(Schema newSchema) {
        boolean retval = this.m_currentSchema == null || !this.m_pro.getDescriptor().areNamesEqual(newSchema.getName(), this.m_currentSchema.getName(), "SCHEMA", false);
        return retval;
    }

    private boolean isSameAsOriginal(DBObject dbObject) {
        Schema schema;
        String objType = dbObject.getType();
        boolean retval = this.m_pro.getDescriptor().areNamesEqual(dbObject.getName(), this.m_originalName, objType, false);
        if (retval && this.m_originalSchema != null && dbObject instanceof SchemaObject && (schema = ((SchemaObject)dbObject).getSchema()) != null) {
            retval = this.m_pro.getDescriptor().areNamesEqual(schema.getName(), this.m_originalSchema.getName(), "SCHEMA", false);
        }
        return retval;
    }
}

