/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.util.ModelUtil;

class MultiProviderPicker
extends DBObjectProviderPicker {
    private final DBUIResourceHelper m_helper = new DBUIResourceHelper("MultiProviderPicker");
    private final List<DatabaseUIExtensionHook.ProviderPickerHash> m_pickers;
    private final MultiPanel m_multiProviderPicker = new MultiPanel();
    private final Map<JRadioButton, DBObjectProviderPicker> m_buttons = new HashMap<JRadioButton, DBObjectProviderPicker>();
    private DBObjectProviderPicker.PickerListener m_pickerListener;

    public MultiProviderPicker(List<DatabaseUIExtensionHook.ProviderPickerHash> viableTypes) {
        this.m_pickers = viableTypes;
    }

    @Override
    public Component getComponent() {
        return this.m_multiProviderPicker;
    }

    @Override
    public void setProvider(String providerType, Object identifier) {
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> e : this.m_buttons.entrySet()) {
            DBObjectProviderPicker picker = e.getValue();
            picker.setProvider(providerType, identifier);
            DBObjectProviderID id = picker.getProviderID();
            if (id == null || !ModelUtil.areEqual((Object)id.getType(), (Object)providerType)) continue;
            e.getKey().setSelected(true);
            break;
        }
        this.setSelectedPickerVisible();
    }

    @Override
    protected DBObjectProvider getProviderImpl() throws DBException {
        DBObjectProvider retval = null;
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> e : this.m_buttons.entrySet()) {
            if (!e.getKey().isSelected()) continue;
            retval = e.getValue().getProvider();
            break;
        }
        return retval;
    }

    @Override
    public DBObjectProviderID getProviderID() {
        DBObjectProviderID retval = null;
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> e : this.m_buttons.entrySet()) {
            if (!e.getKey().isSelected()) continue;
            retval = e.getValue().getProviderID();
            break;
        }
        return retval;
    }

    @Override
    protected boolean isAvailable(DBObjectProviderPicker.PickerConfiguration config) {
        return true;
    }

    @Override
    protected void init(DBObjectProviderPicker.PickerConfiguration config) {
        Object defaultPickerBtn = null;
        String defaultProviderType = this.getDefaultProviderType(config);
        String disabledProviderType = config.shouldDisablePickerForDefaultProvider() && ModelUtil.hasLength((String)defaultProviderType) ? defaultProviderType : null;
        for (DatabaseUIExtensionHook.ProviderPickerHash providerPickerHash : this.m_pickers) {
            String type = providerPickerHash.getProviderType();
            String name = type + "_button";
            String label = providerPickerHash.getLabel();
            JRadioButton btn = new JRadioButton();
            this.m_helper.resButton(btn, label, name);
            DBObjectProviderPicker picker = providerPickerHash.getProviderPicker();
            picker.init(config, type.equals(disabledProviderType));
            this.m_buttons.put(btn, picker);
        }
        this.m_multiProviderPicker.init(config);
        for (Map.Entry entry : this.m_buttons.entrySet()) {
            String pdefType;
            DBObjectProviderPicker picker = (DBObjectProviderPicker)entry.getValue();
            DBObjectProviderID ppid = picker.getProviderID();
            String pprvType = ppid == null ? null : ppid.getType();
            if (!ModelUtil.areEqual((Object)pprvType, (Object)(pdefType = picker.getDefaultProviderType(config)))) continue;
            ((JRadioButton)entry.getKey()).doClick();
            break;
        }
    }

    private void setSelectedPickerVisible() {
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> e : this.m_buttons.entrySet()) {
            Component pickerUIComponent = e.getValue().getComponent();
            pickerUIComponent.setVisible(e.getKey().isSelected());
        }
    }

    @Override
    protected void addImplementationListener() {
        if (this.m_pickerListener == null) {
            this.m_pickerListener = new MyPickerListener();
        }
        if (this.m_buttons == null) {
            throw new IllegalArgumentException("ProviderPicker must be initialized before adding a PickerListener");
        }
        for (DBObjectProviderPicker picker : this.m_buttons.values()) {
            picker.removePickerListener(this.m_pickerListener);
            picker.addPickerListener(this.m_pickerListener);
        }
    }

    @Override
    protected void removeImplementationListener() {
        for (DBObjectProviderPicker picker : this.m_buttons.values()) {
            picker.removePickerListener(this.m_pickerListener);
        }
    }

    private class MultiPanel
    extends JPanel
    implements ActionListener {
        private JLabel m_label = null;
        private JCheckBox m_cbxControlEnable = null;
        private DBUIResourceHelper m_helper = new DBUIResourceHelper("MultiProviderPicker");
        private boolean m_layoutDone;

        private MultiPanel() {
        }

        protected Component getDefaultFocusComponent() {
            Component retval = null;
            for (Map.Entry e : MultiProviderPicker.this.m_buttons.entrySet()) {
                if (!((JRadioButton)e.getKey()).isSelected()) continue;
                retval = ((DBObjectProviderPicker)e.getValue()).getComponent();
                break;
            }
            return retval;
        }

        private void init(DBObjectProviderPicker.PickerConfiguration config) {
            if (!this.m_layoutDone) {
                DBUILayoutHelper layout = new DBUILayoutHelper(this);
                int colCount = 1;
                String label = config.getLabel();
                if (config.getControlEnable()) {
                    this.m_cbxControlEnable = new JCheckBox();
                    if (ModelUtil.hasLength((String)label)) {
                        this.m_helper.resButton(this.m_cbxControlEnable, label, "enable");
                    }
                    ++colCount;
                    layout.add(this.m_cbxControlEnable);
                    this.m_cbxControlEnable.addActionListener(this);
                    ActionListener controlListener = config.getControlEnableListener();
                    if (controlListener != null) {
                        this.m_cbxControlEnable.addActionListener(controlListener);
                    }
                } else if (ModelUtil.hasLength((String)label)) {
                    this.m_label = new JLabel(label);
                    ++colCount;
                    layout.add(this.m_label);
                }
                ButtonGroup bg = new ButtonGroup();
                JRadioButton firstButton = null;
                TreeSet sortedButtons = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        JRadioButton rb1 = (JRadioButton)o1;
                        JRadioButton rb2 = (JRadioButton)o2;
                        String l1 = rb1.getText();
                        String l2 = rb2.getText();
                        return l1.compareTo(l2);
                    }
                });
                sortedButtons.addAll(MultiProviderPicker.this.m_buttons.keySet());
                for (JRadioButton jRadioButton : sortedButtons) {
                    ++colCount;
                    bg.add(jRadioButton);
                    layout.add(jRadioButton);
                    jRadioButton.addActionListener(this);
                    if (firstButton != null) continue;
                    firstButton = jRadioButton;
                }
                layout.pushLeft();
                layout.nextRow();
                layout.setMarginLeft(16);
                for (Map.Entry entry : MultiProviderPicker.this.m_buttons.entrySet()) {
                    Component pickerUIComponent = ((DBObjectProviderPicker)entry.getValue()).getComponent();
                    layout.add(pickerUIComponent, colCount, 1, true, false);
                    layout.nextRow();
                    pickerUIComponent.setVisible(false);
                }
                layout.pushUp();
                layout.layout();
                firstButton.doClick();
                if (config.getControlEnable()) {
                    this.setPickerEnabled(this.m_cbxControlEnable.isSelected());
                } else {
                    this.setPickerEnabled(true);
                }
                this.m_layoutDone = true;
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.m_cbxControlEnable != null) {
                this.m_cbxControlEnable.setSelected(isEnabled);
            } else {
                this.setPickerEnabled(isEnabled);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == this.m_cbxControlEnable) {
                if (this.m_cbxControlEnable.isSelected()) {
                    this.setPickerEnabled(true);
                } else {
                    this.setPickerEnabled(false);
                }
            } else {
                if (MultiProviderPicker.this.m_buttons.keySet().contains(source)) {
                    MultiProviderPicker.this.setSelectedPickerVisible();
                    if (((JRadioButton)source).isSelected()) {
                        DBObjectProviderPicker pp = (DBObjectProviderPicker)MultiProviderPicker.this.m_buttons.get(source);
                        DBObjectProviderID id = pp.getProviderID();
                        MultiProviderPicker.this.firePickerChanged(id);
                    }
                }
                this.repaint();
            }
        }

        private void setPickerEnabled(boolean enabledFlag) {
            if (this.m_label != null) {
                this.m_label.setEnabled(enabledFlag);
            }
            for (Map.Entry e : MultiProviderPicker.this.m_buttons.entrySet()) {
                ((JRadioButton)e.getKey()).setEnabled(enabledFlag);
                ((DBObjectProviderPicker)e.getValue()).setPickerEnabled(enabledFlag);
            }
        }
    }

    private class MyPickerListener
    implements DBObjectProviderPicker.PickerListener {
        private MyPickerListener() {
        }

        @Override
        public void providerChanged(DBObjectProviderID providerID) {
            MultiProviderPicker.this.firePickerChanged(providerID);
        }
    }
}

