/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;

public class DBObjectTypePicker {
    private final CheckBoxListModel m_typeBoxes;
    private final CheckBoxListPanel m_typesPanel;
    private final JLabel m_typesDialogErrorLabel = new JLabel();
    private final Collection<String> m_chosenTypes = new TreeSet<String>();
    private String m_name;
    private JEWTDialog m_typesDialog;

    public DBObjectTypePicker() {
        this.m_typeBoxes = new CheckBoxListModel();
        this.m_typesPanel = new CheckBoxListPanel(this.m_typeBoxes);
        this.m_typesPanel.getList().setLayoutOrientation(1);
        this.setComponentName("DBObjectTypePicker");
    }

    public void setComponentName(String name) {
        this.m_name = name;
        this.m_typesPanel.setName(name + ".Panel");
        this.m_typesPanel.getList().setName(name + ".List");
        this.m_typesPanel.getSelectAllButton().setName(name + ".SelectAll");
        this.m_typesPanel.getDeselectAllButton().setName(name + ".DeselectAll");
    }

    public void setAvailableTypes(DBObjectProvider pro, boolean include, String ... types) {
        boolean hasTypes;
        boolean bl = hasTypes = types != null && types.length != 0;
        if (!(hasTypes && include || pro != null)) {
            throw new IllegalArgumentException("Need a DBObjectProvider, or included types.");
        }
        this.m_chosenTypes.clear();
        this.m_typeBoxes.clear();
        if (hasTypes) {
            if (include) {
                for (String type : types) {
                    if (type == null || pro != null && !pro.supportsObjectType(type)) continue;
                    this.m_chosenTypes.add(type);
                }
            } else {
                List<String> exclude = Arrays.asList(types);
                for (String type : pro.listObjectTypes()) {
                    if (exclude.contains(type)) continue;
                    this.m_chosenTypes.add(type);
                }
            }
        } else {
            for (String type : pro.listObjectTypes()) {
                this.m_chosenTypes.add(type);
            }
        }
        for (String type : this.m_chosenTypes) {
            this.m_typeBoxes.addElement((Object)type, this.getIcon(type), true, true, this.getLabel(type));
        }
        this.m_typeBoxes.addCheckBoxStateListener(e -> this.checkBoxChanged());
        this.setSelectedTypes(DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter());
    }

    protected String getLabel(String type) {
        return DBTypeDisplayRegistry.getDisplayName(type);
    }

    protected Icon getIcon(String type) {
        return DBTypeDisplayRegistry.getNodeIcon(type);
    }

    public Collection<String> getAvailableTypes() {
        TreeSet<String> retval = new TreeSet<String>();
        for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
            retval.add((String)this.m_typeBoxes.getUserObjectAt(i));
        }
        return retval;
    }

    private void checkBoxChanged() {
        if (this.m_typesDialog == null) {
            this.setChosenTypesFromSelection();
        } else {
            this.updateErrorLabel();
        }
    }

    private void updateErrorLabel() {
        List selected = this.m_typeBoxes.getSelectionList();
        if (selected == null || selected.isEmpty()) {
            this.m_typesDialogErrorLabel.setText(UIBundle.get("PICKER_NO_TYPES_ERR"));
            this.m_typesDialogErrorLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
            this.m_typesDialog.setOKButtonEnabled(false);
        } else {
            this.m_typesDialogErrorLabel.setText(" ");
            this.m_typesDialogErrorLabel.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            this.m_typesDialog.setOKButtonEnabled(true);
        }
    }

    private void setChosenTypesFromSelection() {
        this.m_chosenTypes.clear();
        List selected = this.m_typeBoxes.getSelectionList();
        if (selected != null) {
            for (Object type : selected) {
                if (!(type instanceof String)) continue;
                this.m_chosenTypes.add((String)type);
            }
        }
    }

    public Component getPickerComponent() {
        return this.m_typesPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showFilterTypesDialog(Component parent) {
        if (!SwingUtilities.isEventDispatchThread() || this.m_typesDialog != null) {
            throw new IllegalStateException("Can only show one dialog, on the EDT.");
        }
        this.m_typesDialog = JEWTDialog.createDialog((Component)parent, (String)UIBundle.get("FILTER_TYPES_DIALOG_TITLE"), (int)7);
        DefaultTraversablePanel content = new DefaultTraversablePanel();
        content.setHelpID("f1_db_filter_types_html");
        content.setLayout((LayoutManager)new BorderLayout(0, 5));
        CheckBoxList typeList = this.m_typesPanel.getList();
        JLabel pickerLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)pickerLabel, (Component)typeList, (String)UIBundle.get("PICKER_TYPES"));
        content.add((Component)pickerLabel, (Object)"North");
        content.add(this.getPickerComponent(), (Object)"Center");
        content.add((Component)this.m_typesDialogErrorLabel, (Object)"South");
        this.m_typesDialog.setContent((Component)content);
        this.m_typesDialog.setName(this.m_name);
        this.m_typesDialog.setInitialFocus((Component)typeList);
        boolean retval = false;
        try {
            this.updateErrorLabel();
            retval = this.m_typesDialog.runDialog();
            if (retval) {
                this.setChosenTypesFromSelection();
            } else {
                this.setSelectedTypes(this.m_chosenTypes);
            }
        }
        finally {
            this.m_typesDialog.dispose();
            this.m_typesDialog = null;
        }
        return retval;
    }

    public final Collection<String> getSelectedTypes() {
        return this.m_chosenTypes;
    }

    public final void setSelectedTypes(Collection<String> types) {
        if (types == null || types.isEmpty()) {
            this.m_typeBoxes.selectAll();
        } else {
            this.m_typeBoxes.deselectAll();
            for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
                CheckBoxListCellData data = (CheckBoxListCellData)this.m_typeBoxes.getElementAt(i);
                data.setCheckBoxState(types.contains(data.getUserObject()));
            }
        }
    }

    public final Collection<String> getDefaultSelection() {
        Collection<String> retval;
        Collection<String> defaultTypes = DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter();
        if (defaultTypes.isEmpty()) {
            retval = this.getAvailableTypes();
        } else {
            retval = new TreeSet<String>();
            for (String type : this.getAvailableTypes()) {
                if (!defaultTypes.contains(type)) continue;
                retval.add(type);
            }
        }
        return retval;
    }
}

